/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.jpa.model;

import com.google.common.base.MoreObjects;
import jakarta.mail.internet.AddressException;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.util.Objects;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity(name="JamesDropList")
@Table(name="JAMES_DROP_LIST")
@NamedQueries(value={@NamedQuery(name="listDropListEntries", query="SELECT j FROM JamesDropList j WHERE j.ownerScope = :ownerScope AND j.owner = :owner"), @NamedQuery(name="queryDropListEntry", query="SELECT j FROM JamesDropList j WHERE j.ownerScope = :ownerScope AND j.owner = :owner AND j.deniedEntity IN :deniedEntity"), @NamedQuery(name="removeDropListEntry", query="DELETE FROM JamesDropList j WHERE j.ownerScope = :ownerScope AND j.owner = :owner AND j.deniedEntity = :deniedEntity")})
public class JPADropListEntry
implements PersistenceCapable {
    @Id
    @GeneratedValue
    @Column(name="DROPLIST_ID")
    private long id;
    @Column(name="OWNER_SCOPE", nullable=false)
    private String ownerScope;
    @Column(name="OWNER")
    private String owner;
    @Column(name="DENIED_ENTITY_TYPE", nullable=false)
    private String deniedEntityType;
    @Column(name="DENIED_ENTITY", nullable=false)
    private String deniedEntity;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    private transient Object pcDetachedState;

    public long getId() {
        return JPADropListEntry.pcGetid(this);
    }

    public void setId(long id) {
        JPADropListEntry.pcSetid(this, id);
    }

    public String getOwnerScope() {
        return JPADropListEntry.pcGetownerScope(this);
    }

    public void setOwnerScope(String ownerScope) {
        JPADropListEntry.pcSetownerScope(this, ownerScope);
    }

    public String getOwner() {
        return JPADropListEntry.pcGetowner(this);
    }

    public void setOwner(String owner) {
        JPADropListEntry.pcSetowner(this, owner);
    }

    public String getDeniedEntityType() {
        return JPADropListEntry.pcGetdeniedEntityType(this);
    }

    public void setDeniedEntityType(String deniedEntityType) {
        JPADropListEntry.pcSetdeniedEntityType(this, deniedEntityType);
    }

    public String getDeniedEntity() {
        return JPADropListEntry.pcGetdeniedEntity(this);
    }

    public void setDeniedEntity(String deniedEntity) {
        JPADropListEntry.pcSetdeniedEntity(this, deniedEntity);
    }

    public boolean equals(Object o) {
        if (o instanceof JPADropListEntry) {
            JPADropListEntry jpaDropListEntry = (JPADropListEntry)o;
            return Objects.equals(JPADropListEntry.pcGetid(this), JPADropListEntry.pcGetid(jpaDropListEntry)) && Objects.equals(JPADropListEntry.pcGetownerScope(this), JPADropListEntry.pcGetownerScope(jpaDropListEntry)) && Objects.equals(JPADropListEntry.pcGetowner(this), JPADropListEntry.pcGetowner(jpaDropListEntry)) && Objects.equals(JPADropListEntry.pcGetdeniedEntityType(this), JPADropListEntry.pcGetdeniedEntityType(jpaDropListEntry)) && Objects.equals(JPADropListEntry.pcGetdeniedEntity(this), JPADropListEntry.pcGetdeniedEntity(jpaDropListEntry));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(JPADropListEntry.pcGetid(this), JPADropListEntry.pcGetownerScope(this), JPADropListEntry.pcGetowner(this), JPADropListEntry.pcGetdeniedEntityType(this), JPADropListEntry.pcGetdeniedEntity(this));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", JPADropListEntry.pcGetid(this)).add("ownerScope", (Object)JPADropListEntry.pcGetownerScope(this)).add("owner", (Object)JPADropListEntry.pcGetowner(this)).add("deniedEntityType", (Object)JPADropListEntry.pcGetdeniedEntityType(this)).add("deniedEntity", (Object)JPADropListEntry.pcGetdeniedEntity(this)).toString();
    }

    public DropListEntry toDropListEntry() {
        try {
            DropListEntry.Builder builder = DropListEntry.builder();
            switch (OwnerScope.valueOf((String)JPADropListEntry.pcGetownerScope(this))) {
                case USER: {
                    builder.userOwner(new MailAddress(JPADropListEntry.pcGetowner(this)));
                    break;
                }
                case DOMAIN: {
                    builder.domainOwner(Domain.of((String)JPADropListEntry.pcGetowner(this)));
                    break;
                }
                case GLOBAL: {
                    builder.forAll();
                }
            }
            if (OwnerScope.DOMAIN.name().equals(JPADropListEntry.pcGetdeniedEntityType(this))) {
                builder.denyDomain(Domain.of((String)JPADropListEntry.pcGetdeniedEntity(this)));
            } else {
                builder.denyAddress(new MailAddress(JPADropListEntry.pcGetdeniedEntity(this)));
            }
            return builder.build();
        }
        catch (AddressException e) {
            throw new IllegalArgumentException("Entity could not be parsed as a MailAddress", e);
        }
    }

    public static JPADropListEntry fromDropListEntry(DropListEntry dropListEntry) {
        JPADropListEntry jpaDropListEntry = new JPADropListEntry();
        jpaDropListEntry.setOwnerScope(dropListEntry.getOwnerScope().name());
        jpaDropListEntry.setOwner(dropListEntry.getOwner());
        jpaDropListEntry.setDeniedEntityType(dropListEntry.getDeniedEntityType().name());
        jpaDropListEntry.setDeniedEntity(dropListEntry.getDeniedEntity());
        return jpaDropListEntry;
    }

    public int pcGetEnhancementContractVersion() {
        return 106714633;
    }

    static {
        pcFieldNames = new String[]{"deniedEntity", "deniedEntityType", "id", "owner", "ownerScope"};
        pcFieldTypes = new Class[]{String.class, String.class, Long.TYPE, String.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26};
        PCRegistry.register(JPADropListEntry.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JamesDropList", (PersistenceCapable)new JPADropListEntry());
    }

    protected void pcClearFields() {
        this.deniedEntity = null;
        this.deniedEntityType = null;
        this.id = 0L;
        this.owner = null;
        this.ownerScope = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPADropListEntry jPADropListEntry = new JPADropListEntry();
        if (bl) {
            jPADropListEntry.pcClearFields();
        }
        jPADropListEntry.pcStateManager = stateManager;
        jPADropListEntry.pcCopyKeyFieldsFromObjectId(object);
        return jPADropListEntry;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPADropListEntry jPADropListEntry = new JPADropListEntry();
        if (bl) {
            jPADropListEntry.pcClearFields();
        }
        jPADropListEntry.pcStateManager = stateManager;
        return jPADropListEntry;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.deniedEntity = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.deniedEntityType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.owner = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.ownerScope = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.deniedEntity);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.deniedEntityType);
                return;
            }
            case 2: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.owner);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.ownerScope);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPADropListEntry jPADropListEntry, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.deniedEntity = jPADropListEntry.deniedEntity;
                return;
            }
            case 1: {
                this.deniedEntityType = jPADropListEntry.deniedEntityType;
                return;
            }
            case 2: {
                this.id = jPADropListEntry.id;
                return;
            }
            case 3: {
                this.owner = jPADropListEntry.owner;
                return;
            }
            case 4: {
                this.ownerScope = jPADropListEntry.ownerScope;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPADropListEntry jPADropListEntry = (JPADropListEntry)object;
        if (jPADropListEntry.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPADropListEntry, nArray[i]);
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(2 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(JPADropListEntry.class, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new LongId(JPADropListEntry.class, this.id);
    }

    private static final String pcGetdeniedEntity(JPADropListEntry jPADropListEntry) {
        if (jPADropListEntry.pcStateManager == null) {
            return jPADropListEntry.deniedEntity;
        }
        int n = pcInheritedFieldCount + 0;
        jPADropListEntry.pcStateManager.accessingField(n);
        return jPADropListEntry.deniedEntity;
    }

    private static final void pcSetdeniedEntity(JPADropListEntry jPADropListEntry, String string) {
        if (jPADropListEntry.pcStateManager == null) {
            jPADropListEntry.deniedEntity = string;
            return;
        }
        jPADropListEntry.pcStateManager.settingStringField((PersistenceCapable)jPADropListEntry, pcInheritedFieldCount + 0, jPADropListEntry.deniedEntity, string, 0);
    }

    private static final String pcGetdeniedEntityType(JPADropListEntry jPADropListEntry) {
        if (jPADropListEntry.pcStateManager == null) {
            return jPADropListEntry.deniedEntityType;
        }
        int n = pcInheritedFieldCount + 1;
        jPADropListEntry.pcStateManager.accessingField(n);
        return jPADropListEntry.deniedEntityType;
    }

    private static final void pcSetdeniedEntityType(JPADropListEntry jPADropListEntry, String string) {
        if (jPADropListEntry.pcStateManager == null) {
            jPADropListEntry.deniedEntityType = string;
            return;
        }
        jPADropListEntry.pcStateManager.settingStringField((PersistenceCapable)jPADropListEntry, pcInheritedFieldCount + 1, jPADropListEntry.deniedEntityType, string, 0);
    }

    private static final long pcGetid(JPADropListEntry jPADropListEntry) {
        if (jPADropListEntry.pcStateManager == null) {
            return jPADropListEntry.id;
        }
        int n = pcInheritedFieldCount + 2;
        jPADropListEntry.pcStateManager.accessingField(n);
        return jPADropListEntry.id;
    }

    private static final void pcSetid(JPADropListEntry jPADropListEntry, long l) {
        if (jPADropListEntry.pcStateManager == null) {
            jPADropListEntry.id = l;
            return;
        }
        jPADropListEntry.pcStateManager.settingLongField((PersistenceCapable)jPADropListEntry, pcInheritedFieldCount + 2, jPADropListEntry.id, l, 0);
    }

    private static final String pcGetowner(JPADropListEntry jPADropListEntry) {
        if (jPADropListEntry.pcStateManager == null) {
            return jPADropListEntry.owner;
        }
        int n = pcInheritedFieldCount + 3;
        jPADropListEntry.pcStateManager.accessingField(n);
        return jPADropListEntry.owner;
    }

    private static final void pcSetowner(JPADropListEntry jPADropListEntry, String string) {
        if (jPADropListEntry.pcStateManager == null) {
            jPADropListEntry.owner = string;
            return;
        }
        jPADropListEntry.pcStateManager.settingStringField((PersistenceCapable)jPADropListEntry, pcInheritedFieldCount + 3, jPADropListEntry.owner, string, 0);
    }

    private static final String pcGetownerScope(JPADropListEntry jPADropListEntry) {
        if (jPADropListEntry.pcStateManager == null) {
            return jPADropListEntry.ownerScope;
        }
        int n = pcInheritedFieldCount + 4;
        jPADropListEntry.pcStateManager.accessingField(n);
        return jPADropListEntry.ownerScope;
    }

    private static final void pcSetownerScope(JPADropListEntry jPADropListEntry, String string) {
        if (jPADropListEntry.pcStateManager == null) {
            jPADropListEntry.ownerScope = string;
            return;
        }
        jPADropListEntry.pcStateManager.settingStringField((PersistenceCapable)jPADropListEntry, pcInheritedFieldCount + 4, jPADropListEntry.ownerScope, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

