/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.jpa;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.backends.jpa.TransactionRunner;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.droplists.jpa.model.JPADropListEntry;
import org.apache.james.sieverepository.api.exception.StorageException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JPADropList
implements DropList {
    private static final String OWNER_SCOPE = "ownerScope";
    private static final String OWNER = "owner";
    private static final String DENIED_ENTITY = "deniedEntity";
    private final TransactionRunner transactionRunner;
    private final EntityManagerFactory entityManagerFactory;

    @Inject
    public JPADropList(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.transactionRunner = new TransactionRunner(entityManagerFactory);
    }

    public Mono<Void> add(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        return Mono.fromRunnable(() -> this.transactionRunner.run(entityManager -> entityManager.persist((Object)JPADropListEntry.fromDropListEntry(entry))));
    }

    public Mono<Void> remove(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        return Mono.fromRunnable(() -> this.transactionRunner.runAndHandleException((Consumer)Throwing.consumer(entityManager -> entityManager.createNamedQuery("removeDropListEntry").setParameter(OWNER_SCOPE, (Object)entry.getOwnerScope().name()).setParameter(OWNER, (Object)entry.getOwner()).setParameter(DENIED_ENTITY, (Object)entry.getDeniedEntity()).executeUpdate()), this.throwStorageExceptionConsumer("Unable to remove denied entity " + entry.getDeniedEntity())));
    }

    public Flux<DropListEntry> list(OwnerScope ownerScope, String owner) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Flux.fromStream(() -> this.getDropListEntries(entityManager, ownerScope, owner).map(JPADropListEntry::toDropListEntry)).doFinally(any -> EntityManagerUtils.safelyClose((EntityManager)entityManager));
    }

    public Mono<DropList.Status> query(OwnerScope ownerScope, String owner, MailAddress sender) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0);
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Mono.fromCallable(() -> this.queryDropList(entityManager, ownerScope, owner, sender)).doFinally(any -> EntityManagerUtils.safelyClose((EntityManager)entityManager));
    }

    private Stream<JPADropListEntry> getDropListEntries(EntityManager entityManager, OwnerScope ownerScope, String owner) {
        return entityManager.createNamedQuery("listDropListEntries").setParameter(OWNER_SCOPE, (Object)ownerScope.name()).setParameter(OWNER, (Object)owner).getResultStream();
    }

    private DropList.Status queryDropList(EntityManager entityManager, OwnerScope ownerScope, String owner, MailAddress sender) {
        String specifiedOwner = ownerScope.equals((Object)OwnerScope.GLOBAL) ? "" : owner;
        return entityManager.createNamedQuery("queryDropListEntry").setParameter(OWNER_SCOPE, (Object)ownerScope.name()).setParameter(OWNER, (Object)specifiedOwner).setParameter(DENIED_ENTITY, List.of(sender.asString(), sender.getDomain().asString())).getResultList().isEmpty() ? DropList.Status.ALLOWED : DropList.Status.BLOCKED;
    }

    private Consumer<PersistenceException> throwStorageExceptionConsumer(String message) {
        return Throwing.consumer(e -> {
            throw new StorageException(message, (Throwable)e);
        }).sneakyThrow();
    }
}

