/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.model.PartContentDescriptor;
import org.apache.james.mailbox.model.Profiles;

public class FetchGroup
extends Profiles<FetchGroup> {
    public static final FetchGroup MINIMAL = new FetchGroup(EnumSet.noneOf(Profile.class));
    public static final FetchGroup HEADERS = new FetchGroup(EnumSet.of(Profile.HEADERS));
    public static final FetchGroup HEADERS_WITH_ATTACHMENTS_METADATA = new FetchGroup(EnumSet.of(Profile.HEADERS_WITH_ATTACHMENTS_METADATA));
    public static final FetchGroup FULL_CONTENT = new FetchGroup(EnumSet.of(Profile.FULL_CONTENT));
    public static final FetchGroup BODY_CONTENT = new FetchGroup(EnumSet.of(Profile.BODY_CONTENT));
    private final ImmutableSet<PartContentDescriptor> partContentDescriptors;

    @VisibleForTesting
    FetchGroup(Collection<Profile> content) {
        this(content, (ImmutableSet<PartContentDescriptor>)ImmutableSet.of());
    }

    @VisibleForTesting
    public FetchGroup(Collection<Profile> content, ImmutableSet<PartContentDescriptor> partContentDescriptors) {
        super(content);
        this.partContentDescriptors = partContentDescriptors;
    }

    @Override
    protected FetchGroup copyWith(Collection<Profile> profiles) {
        return new FetchGroup(profiles, this.partContentDescriptors);
    }

    public Set<PartContentDescriptor> getPartContentDescriptors() {
        return this.partContentDescriptors;
    }

    public FetchGroup addPartContent(MimePath path, EnumSet<Profile> profiles) {
        PartContentDescriptor newContent = this.retrieveUpdatedPartContentDescriptor(path, profiles);
        return new FetchGroup(this.profiles(), (ImmutableSet<PartContentDescriptor>)((ImmutableSet)Stream.concat(this.partContentDescriptors.stream().filter(descriptor -> !descriptor.path().equals(path)), Stream.of(newContent)).collect(ImmutableSet.toImmutableSet())));
    }

    public FetchGroup addPartContent(MimePath path, Profile ... profiles) {
        return this.addPartContent(path, EnumSet.copyOf(Arrays.asList(profiles)));
    }

    private PartContentDescriptor retrieveUpdatedPartContentDescriptor(MimePath path, EnumSet<Profile> profiles) {
        return this.partContentDescriptors.stream().filter(descriptor -> path.equals(descriptor.path())).findFirst().orElseGet(() -> new PartContentDescriptor(profiles, path));
    }

    public String toString() {
        return "Fetch " + String.valueOf(this.profiles());
    }

    public final boolean equals(Object o) {
        if (o instanceof FetchGroup) {
            FetchGroup that = (FetchGroup)o;
            return Objects.equals(this.profiles(), that.profiles()) && Objects.equals(this.partContentDescriptors, that.partContentDescriptors);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.profiles(), this.partContentDescriptors);
    }

    public static enum Profile {
        MIME_DESCRIPTOR,
        HEADERS,
        HEADERS_WITH_ATTACHMENTS_METADATA,
        FULL_CONTENT,
        BODY_CONTENT,
        MIME_HEADERS,
        MIME_CONTENT;

    }
}

