/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.rate.limiter.api.AcceptableRate$;
import org.apache.james.rate.limiter.api.RateExceeded$;
import org.apache.james.rate.limiter.api.RateLimiter;
import org.apache.james.rate.limiter.api.RateLimiterFactory;
import org.apache.james.rate.limiter.api.RateLimitingResult;
import org.apache.james.rate.limiter.api.Rules;
import org.apache.james.transport.mailets.ConfigurationOps$;
import org.apache.james.transport.mailets.Count$;
import org.apache.james.transport.mailets.EntityType;
import org.apache.james.transport.mailets.EntityType$;
import org.apache.james.transport.mailets.GlobalRateLimiter;
import org.apache.james.transport.mailets.GlobalRateLimiter$;
import org.apache.james.transport.mailets.KeyPrefix;
import org.apache.james.transport.mailets.KeyPrefix$;
import org.apache.james.transport.mailets.Recipients$;
import org.apache.james.transport.mailets.Size$;
import org.apache.james.transport.mailets.TotalSize$;
import org.apache.mailet.Mail;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.jdk.DurationConverters;
import scala.jdk.DurationConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\u000f\u001e\u0001!B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006y\u0001!\t!\u0010\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\n-C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002)\t\u0013e\u0003\u0001\u0019!A!B\u0013a\u0005\"\u0003.\u0001\u0001\u0004\u0005\r\u0011\"\u0003L\u0011%Y\u0006\u00011AA\u0002\u0013%A\fC\u0005_\u0001\u0001\u0007\t\u0011)Q\u0005\u0019\"Iq\f\u0001a\u0001\u0002\u0004%Ia\u0013\u0005\nA\u0002\u0001\r\u00111A\u0005\n\u0005D\u0011b\u0019\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0013Y\u0005\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%A\u0007\u00011A\u0001B\u0003&A\nC\u0005j\u0001\u0001\u0007\t\u0019!C\u0005U\"Ia\u000f\u0001a\u0001\u0002\u0004%Ia\u001e\u0005\ns\u0002\u0001\r\u0011!Q!\n-D\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011B>\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011q\u0001\u0005\u000b\u0003\u0017\u0001\u0001\u0019!A!B\u0013a\bbCA\u0007\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fA1\"a\t\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002&!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\t\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\tyq\t\\8cC2\u0014\u0016\r^3MS6LGO\u0003\u0002\u001f?\u00059Q.Y5mKR\u001c(B\u0001\u0011\"\u0003%!(/\u00198ta>\u0014HO\u0003\u0002#G\u0005)!.Y7fg*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00022bg\u0016T!AL\u0012\u0002\r5\f\u0017\u000e\\3u\u0013\t\u00014FA\u0007HK:,'/[2NC&dW\r^\u0001\u0013e\u0006$X\rT5nSR,'OR1di>\u0014\u0018\u0010\u0005\u00024u5\tAG\u0003\u00026m\u0005\u0019\u0011\r]5\u000b\u0005]B\u0014a\u00027j[&$XM\u001d\u0006\u0003s\u0005\nAA]1uK&\u00111\b\u000e\u0002\u0013%\u0006$X\rT5nSR,'OR1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0003}\u0001\u0003\"a\u0010\u0001\u000e\u0003uAQ!\r\u0002A\u0002IB#A\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015AB5oU\u0016\u001cGOC\u0001H\u0003\u001dQ\u0017m[1si\u0006L!!\u0013#\u0003\r%s'.Z2u\u0003A\u0019w.\u001e8u%\u0006$X\rT5nSR,'/F\u0001M!\tyT*\u0003\u0002O;\t\tr\t\\8cC2\u0014\u0016\r^3MS6LG/\u001a:\u0002)\r|WO\u001c;SCR,G*[7ji\u0016\u0014x\fJ3r)\t\tv\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0003V]&$\bb\u0002-\u0005\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0014!E2pk:$(+\u0019;f\u0019&l\u0017\u000e^3sA\u0005)\"/Z2ja&,g\u000e^:SCR,G*[7ji\u0016\u0014\u0018!\u0007:fG&\u0004\u0018.\u001a8ugJ\u000bG/\u001a'j[&$XM]0%KF$\"!U/\t\u000fa;\u0011\u0011!a\u0001\u0019\u00061\"/Z2ja&,g\u000e^:SCR,G*[7ji\u0016\u0014\b%A\btSj,'+\u0019;f\u0019&l\u0017\u000e^3s\u0003M\u0019\u0018N_3SCR,G*[7ji\u0016\u0014x\fJ3r)\t\t&\rC\u0004Y\u0015\u0005\u0005\t\u0019\u0001'\u0002!ML'0\u001a*bi\u0016d\u0015.\\5uKJ\u0004\u0013\u0001\u0006;pi\u0006d7+\u001b>f%\u0006$X\rT5nSR,'/\u0001\ru_R\fGnU5{KJ\u000bG/\u001a'j[&$XM]0%KF$\"!U4\t\u000fak\u0011\u0011!a\u0001\u0019\u0006)Bo\u001c;bYNK'0\u001a*bi\u0016d\u0015.\\5uKJ\u0004\u0013!E3yG\u0016,G-\u001a3Qe>\u001cWm]:peV\t1\u000e\u0005\u0002mg:\u0011Q.\u001d\t\u0003]Nk\u0011a\u001c\u0006\u0003a\u001e\na\u0001\u0010:p_Rt\u0014B\u0001:T\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u001c\u0016!F3yG\u0016,G-\u001a3Qe>\u001cWm]:pe~#S-\u001d\u000b\u0003#bDq\u0001\u0017\t\u0002\u0002\u0003\u00071.\u0001\nfq\u000e,W\rZ3e!J|7-Z:t_J\u0004\u0013!C6fsB\u0013XMZ5y+\u0005a\bc\u0001*~\u007f&\u0011ap\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007}\n\t!C\u0002\u0002\u0004u\u0011\u0011bS3z!J,g-\u001b=\u0002\u001b-,\u0017\u0010\u0015:fM&Dx\fJ3r)\r\t\u0016\u0011\u0002\u0005\b1N\t\t\u00111\u0001}\u0003)YW-\u001f)sK\u001aL\u0007\u0010I\u0001\u0013e\u0006$X\rT5nSR,'\u000fV5nK>,H/\u0006\u0002\u0002\u0012A!!+`A\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\tA\u0001^5nK*\u0011\u0011QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\"\u0005]!\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002-I\fG/\u001a'j[&$XM\u001d+j[\u0016|W\u000f^0%KF$2!UA\u0014\u0011!Af#!AA\u0002\u0005E\u0011a\u0005:bi\u0016d\u0015.\\5uKJ$\u0016.\\3pkR\u0004\u0013\u0001B5oSR$\u0012!U\u0001\bg\u0016\u0014h/[2f)\r\t\u00161\u0007\u0005\b\u0003kI\u0002\u0019AA\u001c\u0003\u0011i\u0017-\u001b7\u0011\t\u0005e\u00121H\u0007\u0002[%\u0019\u0011QH\u0017\u0003\t5\u000b\u0017\u000e\\\u0001\u0012GJ,\u0017\r^3SCR,G*[7ji\u0016\u0014Hc\u0003'\u0002D\u0005\u0015\u0013qJA)\u0003+BQ!\r\u000eA\u0002IBq!a\u0012\u001b\u0001\u0004\tI%\u0001\u0006f]RLG/\u001f+za\u0016\u00042aPA&\u0013\r\ti%\b\u0002\u000b\u000b:$\u0018\u000e^=UsB,\u0007\"\u0002>\u001b\u0001\u0004a\bbBA*5\u0001\u0007\u00111C\u0001\tIV\u0014\u0018\r^5p]\"9\u0011q\u000b\u000eA\u0002\u0005E\u0011!\u00039sK\u000eL7/[8o\u0003]\u0011X-];je\u0016$\u0007K]8dKN\u001c\u0018N\\4Ti\u0006$X\r\u0006\u0002\u0002^A1\u0011qLA3\u0003Sj!!!\u0019\u000b\t\u0005\r\u00141D\u0001\u0005kRLG.\u0003\u0003\u0002h\u0005\u0005$AC\"pY2,7\r^5p]B!\u0011\u0011HA6\u0013\r\ti'\f\u0002\u0010!J|7-Z:tS:<7\u000b^1uK\u0002")
public class GlobalRateLimit
extends GenericMailet {
    private final RateLimiterFactory rateLimiterFactory;
    private GlobalRateLimiter countRateLimiter;
    private GlobalRateLimiter recipientsRateLimiter;
    private GlobalRateLimiter sizeRateLimiter;
    private GlobalRateLimiter totalSizeRateLimiter;
    private String exceededProcessor;
    private Option<KeyPrefix> keyPrefix;
    private Option<java.time.Duration> rateLimiterTimeout;

    private GlobalRateLimiter countRateLimiter() {
        return this.countRateLimiter;
    }

    private void countRateLimiter_$eq(GlobalRateLimiter x$1) {
        this.countRateLimiter = x$1;
    }

    private GlobalRateLimiter recipientsRateLimiter() {
        return this.recipientsRateLimiter;
    }

    private void recipientsRateLimiter_$eq(GlobalRateLimiter x$1) {
        this.recipientsRateLimiter = x$1;
    }

    private GlobalRateLimiter sizeRateLimiter() {
        return this.sizeRateLimiter;
    }

    private void sizeRateLimiter_$eq(GlobalRateLimiter x$1) {
        this.sizeRateLimiter = x$1;
    }

    private GlobalRateLimiter totalSizeRateLimiter() {
        return this.totalSizeRateLimiter;
    }

    private void totalSizeRateLimiter_$eq(GlobalRateLimiter x$1) {
        this.totalSizeRateLimiter = x$1;
    }

    private String exceededProcessor() {
        return this.exceededProcessor;
    }

    private void exceededProcessor_$eq(String x$1) {
        this.exceededProcessor = x$1;
    }

    private Option<KeyPrefix> keyPrefix() {
        return this.keyPrefix;
    }

    private void keyPrefix_$eq(Option<KeyPrefix> x$1) {
        this.keyPrefix = x$1;
    }

    private Option<java.time.Duration> rateLimiterTimeout() {
        return this.rateLimiterTimeout;
    }

    private void rateLimiterTimeout_$eq(Option<java.time.Duration> x$1) {
        this.rateLimiterTimeout = x$1;
    }

    public void init() {
        java.time.Duration duration = (java.time.Duration)ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("duration").getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("'duration' is compulsory");
        });
        Option<java.time.Duration> precision = ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("precision");
        this.keyPrefix_$eq((Option<KeyPrefix>)Option$.MODULE$.apply((Object)this.getInitParameter("keyPrefix")).map((Function1)KeyPrefix$.MODULE$));
        this.exceededProcessor_$eq(this.getInitParameter("exceededProcessor", "error"));
        this.rateLimiterTimeout_$eq(ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("rateLimiterTimeout"));
        Preconditions.checkArgument((this.rateLimiterTimeout().isEmpty() || ((java.time.Duration)this.rateLimiterTimeout().get()).isPositive() ? 1 : 0) != 0, (Object)"rateLimiterTimeout can not be negative");
        this.countRateLimiter_$eq(this.globalRateLimiter$1(Count$.MODULE$, duration, precision));
        this.recipientsRateLimiter_$eq(this.globalRateLimiter$1(Recipients$.MODULE$, duration, precision));
        this.sizeRateLimiter_$eq(this.globalRateLimiter$1(Size$.MODULE$, duration, precision));
        this.totalSizeRateLimiter_$eq(this.globalRateLimiter$1(TotalSize$.MODULE$, duration, precision));
    }

    public void service(Mail mail) {
        AcceptableRate$ pivot = AcceptableRate$.MODULE$;
        SMono rateLimitChecker = SFlux$.MODULE$.merge((Seq)new .colon.colon(this.countRateLimiter().rateLimit(mail), (List)new .colon.colon(this.recipientsRateLimiter().rateLimit(mail), (List)new .colon.colon(this.sizeRateLimiter().rateLimit(mail), (List)new .colon.colon(this.totalSizeRateLimiter().rateLimit(mail), (List)Nil$.MODULE$)))), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).fold((Object)pivot, (Function2 & Serializable)(a, b) -> a.merge((RateLimitingResult)b));
        RateLimitingResult result = (RateLimitingResult)this.rateLimiterTimeout().map((Function1 & Serializable)timeout -> (RateLimitingResult)rateLimitChecker.block((Duration)DurationConverters.JavaDurationOps$.MODULE$.toScala$extension(DurationConverters$.MODULE$.JavaDurationOps(timeout)))).getOrElse((Function0 & Serializable)() -> (RateLimitingResult)rateLimitChecker.block(rateLimitChecker.block$default$1()));
        if (result.equals(RateExceeded$.MODULE$)) {
            mail.setState(this.exceededProcessor());
            return;
        }
    }

    private GlobalRateLimiter createRateLimiter(RateLimiterFactory rateLimiterFactory, EntityType entityType, Option<KeyPrefix> keyPrefix, java.time.Duration duration, Option<java.time.Duration> precision) {
        return (GlobalRateLimiter)EntityType$.MODULE$.extractRules(entityType, duration, this.getMailetConfig()).map((Function1 & Serializable)x$8 -> rateLimiterFactory.withSpecification((Rules)x$8, precision)).map((Function1 & Serializable)rateLimiter -> GlobalRateLimiter$.MODULE$.fromRateLimiter((RateLimiter)rateLimiter, keyPrefix, entityType)).getOrElse((Function0 & Serializable)() -> GlobalRateLimiter$.MODULE$.acceptAll());
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return ImmutableList.of((Object)new ProcessingState(this.exceededProcessor()));
    }

    private final GlobalRateLimiter globalRateLimiter$1(EntityType entityType, java.time.Duration duration$1, Option precision$1) {
        return this.createRateLimiter(this.rateLimiterFactory, entityType, this.keyPrefix(), duration$1, (Option<java.time.Duration>)precision$1);
    }

    @Inject
    public GlobalRateLimit(RateLimiterFactory rateLimiterFactory) {
        this.rateLimiterFactory = rateLimiterFactory;
    }
}

