/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.core.limiter.request;

import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface RequestLimitRulesSupplier<T> {
    public static Set<RequestLimitRule> buildDefaultRuleSet(Set<RequestLimitRule> rules) {
        return rules.stream().filter(rule -> rule.getKeys() == null).collect(Collectors.toSet());
    }

    public static Map<String, Set<RequestLimitRule>> buildRuleMap(Set<RequestLimitRule> rules) {
        HashMap<String, Set<RequestLimitRule>> ruleMap = new HashMap<String, Set<RequestLimitRule>>();
        for (RequestLimitRule rule : rules) {
            if (rule.getKeys() == null) continue;
            for (String key : rule.getKeys()) {
                ruleMap.computeIfAbsent(key, k -> new HashSet()).add(rule);
            }
        }
        return ruleMap;
    }

    public T getRules(String var1);
}

