/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.core.limiter.request;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RequestLimitRule {
    private final int durationSeconds;
    private final long limit;
    private final int precision;
    private final String name;
    private final Set<String> keys;

    private RequestLimitRule(int durationSeconds, long limit, int precision) {
        this(durationSeconds, limit, precision, null);
    }

    private RequestLimitRule(int durationSeconds, long limit, int precision, String name) {
        this(durationSeconds, limit, precision, name, null);
    }

    private RequestLimitRule(int durationSeconds, long limit, int precision, String name, Set<String> keys) {
        this.durationSeconds = durationSeconds;
        this.limit = limit;
        this.precision = precision;
        this.name = name;
        this.keys = keys;
    }

    private static void checkDuration(Duration duration) {
        Objects.requireNonNull(duration, "duration can not be null");
        if (Duration.ofSeconds(1L).compareTo(duration) > 0) {
            throw new IllegalArgumentException("duration must be great than 1 second");
        }
    }

    public static RequestLimitRule of(Duration duration, long limit) {
        RequestLimitRule.checkDuration(duration);
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must be greater than zero.");
        }
        int durationSeconds = (int)duration.getSeconds();
        return new RequestLimitRule(durationSeconds, limit, durationSeconds);
    }

    public RequestLimitRule withPrecision(Duration precision) {
        RequestLimitRule.checkDuration(precision);
        return new RequestLimitRule(this.durationSeconds, this.limit, (int)precision.getSeconds(), this.name, this.keys);
    }

    public RequestLimitRule withName(String name) {
        return new RequestLimitRule(this.durationSeconds, this.limit, this.precision, name, this.keys);
    }

    public RequestLimitRule matchingKeys(String ... keys) {
        HashSet<String> keySet = keys.length > 0 ? new HashSet<String>(Arrays.asList(keys)) : null;
        return this.matchingKeys(keySet);
    }

    public RequestLimitRule matchingKeys(Set<String> keys) {
        return new RequestLimitRule(this.durationSeconds, this.limit, this.precision, this.name, keys);
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public int getPrecisionSeconds() {
        return this.precision;
    }

    public String getName() {
        return this.name;
    }

    public long getLimit() {
        return this.limit;
    }

    @Nullable
    public Set<String> getKeys() {
        return this.keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RequestLimitRule)) {
            return false;
        }
        RequestLimitRule that = (RequestLimitRule)o;
        return this.durationSeconds == that.durationSeconds && this.limit == that.limit && Objects.equals(this.precision, that.precision) && Objects.equals(this.name, that.name) && Objects.equals(this.keys, that.keys);
    }

    public int hashCode() {
        return Objects.hash(this.durationSeconds, this.limit, this.precision, this.name, this.keys);
    }
}

