/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.core.limiter.concurrent;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ConcurrentLimitRule {
    private final int concurrentLimit;
    private final long timeoutMillis;
    private final String name;

    private ConcurrentLimitRule(int concurrentLimit, long timeoutMillis) {
        this(concurrentLimit, timeoutMillis, null);
    }

    private ConcurrentLimitRule(int concurrentLimit, long timeoutMillis, String name) {
        this.concurrentLimit = concurrentLimit;
        this.timeoutMillis = timeoutMillis;
        this.name = name;
    }

    public static ConcurrentLimitRule of(int concurrentLimit, TimeUnit timeOutUnit, long timeOut) {
        Objects.requireNonNull(timeOutUnit, "time out unit can not be null");
        return new ConcurrentLimitRule(concurrentLimit, timeOutUnit.toMillis(timeOut));
    }

    public ConcurrentLimitRule withName(String name) {
        return new ConcurrentLimitRule(this.concurrentLimit, this.timeoutMillis, name);
    }

    public int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ConcurrentLimitRule)) {
            return false;
        }
        ConcurrentLimitRule that = (ConcurrentLimitRule)o;
        return this.concurrentLimit == that.concurrentLimit && this.timeoutMillis == that.timeoutMillis && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.concurrentLimit, this.timeoutMillis, this.name);
    }
}

