/*
 * Decompiled with CFR 0.152.
 */
package de.jkeylockmanager.manager.implementation.lockstripe;

import de.jkeylockmanager.manager.exception.KeyLockManagerInterruptedException;
import de.jkeylockmanager.manager.exception.KeyLockManagerTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

final class CountingLock {
    private final ReentrantLock delegate = new ReentrantLock();
    private final long lockTimeout;
    private final TimeUnit lockTimeoutUnit;
    private long uses = 0L;

    CountingLock(long lockTimeout, TimeUnit lockTimeoutUnit) {
        assert (lockTimeout > 0L) : "contract broken: lockTimeout > 0";
        assert (lockTimeoutUnit != null) : "contract broken: lockTimeoutUnit != null";
        this.lockTimeout = lockTimeout;
        this.lockTimeoutUnit = lockTimeoutUnit;
    }

    void decrementUses() {
        --this.uses;
    }

    int getQueueLength() {
        return this.delegate.getQueueLength();
    }

    void incrementUses() {
        ++this.uses;
    }

    boolean isUsed() {
        return this.uses != 0L;
    }

    void tryLock() {
        try {
            if (!this.delegate.tryLock(this.lockTimeout, this.lockTimeoutUnit)) {
                throw new KeyLockManagerTimeoutException(this.lockTimeout, this.lockTimeoutUnit);
            }
        }
        catch (InterruptedException e) {
            throw new KeyLockManagerInterruptedException();
        }
    }

    void unlock() {
        this.delegate.unlock();
    }
}

