/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.pulsar;

import jakarta.mail.internet.MimeMessage;
import java.util.Optional;
import org.apache.james.backends.pulsar.DockerPulsarExtension;
import org.apache.james.backends.pulsar.PulsarClients;
import org.apache.james.backends.pulsar.PulsarConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.PlainBlobId;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.blob.memory.MemoryBlobStoreDAO;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueFactoryContract;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueMetricExtension;
import org.apache.james.queue.api.ManageableMailQueueFactoryContract;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.pulsar.PulsarMailQueue;
import org.apache.james.queue.pulsar.PulsarMailQueueFactory;
import org.apache.james.server.blob.deduplication.PassThroughBlobStore;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;

@Tag(value="unstable")
@Extensions(value={@ExtendWith(value={MailQueueMetricExtension.class}), @ExtendWith(value={DockerPulsarExtension.class})})
class PulsarMailQueueFactoryTest
implements MailQueueFactoryContract<PulsarMailQueue>,
ManageableMailQueueFactoryContract<PulsarMailQueue> {
    PulsarMailQueueFactory mailQueueFactory;
    private PlainBlobId.Factory blobIdFactory;
    private Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private MailQueueItemDecoratorFactory factory;
    private PulsarConfiguration config;
    private MailQueueMetricExtension.MailQueueMetricTestSystem metricTestSystem;
    private PulsarClients pulsarClients;

    PulsarMailQueueFactoryTest() {
    }

    @BeforeEach
    void setUp(DockerPulsarExtension.DockerPulsar dockerPulsar, MailQueueMetricExtension.MailQueueMetricTestSystem metricTestSystem) throws PulsarClientException, PulsarAdminException {
        this.metricTestSystem = metricTestSystem;
        this.blobIdFactory = new PlainBlobId.Factory();
        MemoryBlobStoreDAO memoryBlobStore = new MemoryBlobStoreDAO();
        PassThroughBlobStore blobStore = new PassThroughBlobStore((BlobStoreDAO)memoryBlobStore, BucketName.DEFAULT, (BlobId.Factory)this.blobIdFactory);
        MimeMessageStore.Factory mimeMessageStoreFactory = new MimeMessageStore.Factory((BlobStore)blobStore);
        this.mimeMessageStore = mimeMessageStoreFactory.mimeMessageStore();
        this.factory = new RawMailQueueItemDecoratorFactory();
        this.config = dockerPulsar.getConfiguration();
        this.pulsarClients = PulsarClients.create((PulsarConfiguration)this.config);
        this.mailQueueFactory = this.newInstance();
    }

    @AfterEach
    void tearDown() {
        this.mailQueueFactory.stop();
        this.pulsarClients.stop();
    }

    private PulsarMailQueueFactory newInstance() {
        return new PulsarMailQueueFactory(this.config, this.pulsarClients, (BlobId.Factory)this.blobIdFactory, this.mimeMessageStore, this.factory, (MetricFactory)this.metricTestSystem.getMetricFactory(), this.metricTestSystem.getSpyGaugeRegistry());
    }

    public MailQueueFactory<PulsarMailQueue> getMailQueueFactory() {
        return this.mailQueueFactory;
    }

    @Test
    void createAlreadyCreatedQueueShouldReturnPreviouslyCreatedMailQueueInstance() {
        MailQueueFactory<PulsarMailQueue> mailQueueFactory = this.getMailQueueFactory();
        PulsarMailQueue queue1 = (PulsarMailQueue)mailQueueFactory.createQueue(MailQueueFactoryContract.NAME_1);
        PulsarMailQueue queue2 = (PulsarMailQueue)mailQueueFactory.createQueue(MailQueueFactoryContract.NAME_1);
        Assertions.assertThat((Object)queue1).isSameAs((Object)queue2);
    }

    @Test
    void getExistingMailQueueShouldReturnPreviouslyCreatedMailQueueInstance() {
        MailQueueFactory<PulsarMailQueue> mailQueueFactory = this.getMailQueueFactory();
        PulsarMailQueue queue1 = (PulsarMailQueue)mailQueueFactory.createQueue(MailQueueFactoryContract.NAME_1);
        Optional queue2 = mailQueueFactory.getQueue(MailQueueFactoryContract.NAME_1);
        Assertions.assertThat((Object)((PulsarMailQueue)queue2.get())).isSameAs((Object)queue1);
    }
}

