/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver;

import com.github.fge.lambdas.Throwing;
import com.google.inject.Binder;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.InMemoryDNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lmtpserver.netty.LMTPServerFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.mock.ConfigLoader;
import org.apache.james.protocols.lib.mock.MockProtocolHandlerLoader;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.lib.AliasReverseResolverImpl;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LmtpServerTest {
    private MemoryDomainList domainList;
    private MemoryUsersRepository usersRepository;
    private InMemoryDNSService dnsService;
    private FileSystem fileSystem;
    private LMTPServerFactory lmtpServerFactory;

    LmtpServerTest() {
    }

    static int getLmtpPort(LMTPServerFactory lmtpServerFactory) {
        return lmtpServerFactory.getServers().stream().findFirst().flatMap(server -> server.getListenAddresses().stream().findFirst()).map(InetSocketAddress::getPort).orElseThrow(() -> new IllegalStateException("LMTP server not defined"));
    }

    @BeforeEach
    void setUpTestEnvironment() throws Exception {
        this.dnsService = new InMemoryDNSService().registerMxRecord(Domain.LOCALHOST.asString(), "127.0.0.1").registerMxRecord("examplebis.local", "127.0.0.1").registerMxRecord("127.0.0.1", "127.0.0.1");
        this.domainList = new MemoryDomainList((DNSService)this.dnsService);
        this.domainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
        this.domainList.addDomain(Domain.of((String)"examplebis.local"));
        this.usersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)this.domainList);
        this.usersRepository.addUser(Username.of((String)"bob@examplebis.local"), "pwd");
        this.usersRepository.addUser(Username.of((String)"cedric@examplebis.local"), "pwd");
        this.fileSystem = FileSystemImpl.forTestingWithConfigurationFromClasspath();
    }

    @AfterEach
    void tearDown() {
        this.lmtpServerFactory.destroy();
    }

    private MockProtocolHandlerLoader.Builder createMockProtocolHandlerLoaderBase() {
        MemoryRecipientRewriteTable rewriteTable = new MemoryRecipientRewriteTable();
        rewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
        AliasReverseResolverImpl aliasReverseResolver = new AliasReverseResolverImpl((RecipientRewriteTable)rewriteTable);
        CanSendFromImpl canSendFrom = new CanSendFromImpl((AliasReverseResolver)aliasReverseResolver);
        return MockProtocolHandlerLoader.builder().put(binder -> binder.bind(DomainList.class).toInstance((Object)this.domainList)).put(binder -> binder.bind(RecipientRewriteTable.class).toInstance((Object)rewriteTable)).put(arg_0 -> LmtpServerTest.lambda$createMockProtocolHandlerLoaderBase$4((CanSendFrom)canSendFrom, arg_0)).put(binder -> binder.bind(FileSystem.class).toInstance((Object)this.fileSystem)).put(binder -> binder.bind(DNSService.class).toInstance((Object)this.dnsService)).put(binder -> binder.bind(UsersRepository.class).toInstance((Object)this.usersRepository)).put(binder -> binder.bind(MetricFactory.class).to(RecordingMetricFactory.class)).put(binder -> binder.bind(UserEntityValidator.class).toInstance((Object)UserEntityValidator.NOOP));
    }

    private LMTPServerFactory createLMTPServer(MockProtocolHandlerLoader loader, String configuration) throws Exception {
        LMTPServerFactory lmtpServerFactory = new LMTPServerFactory((ProtocolHandlerLoader)loader, this.fileSystem, (MetricFactory)new RecordingMetricFactory());
        lmtpServerFactory.configure((HierarchicalConfiguration)ConfigLoader.getConfig((InputStream)ClassLoader.getSystemResourceAsStream(configuration)));
        lmtpServerFactory.init();
        return lmtpServerFactory;
    }

    private byte[] readBytes(SocketChannel channel) throws IOException {
        ByteBuffer line = ByteBuffer.allocate(1024);
        channel.read(line);
        line.rewind();
        byte[] bline = new byte[line.remaining()];
        line.get(bline);
        return bline;
    }

    private static /* synthetic */ void lambda$createMockProtocolHandlerLoaderBase$4(CanSendFrom canSendFrom, Binder binder) {
        binder.bind(CanSendFrom.class).toInstance((Object)canSendFrom);
    }

    @Nested
    class NormalTest {
        private InMemoryMailboxManager mailboxManager;

        NormalTest() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.mailboxManager = InMemoryIntegrationResources.defaultResources().getMailboxManager();
            LmtpServerTest.this.lmtpServerFactory = LmtpServerTest.this.createLMTPServer(LmtpServerTest.this.createMockProtocolHandlerLoaderBase().put(binder -> binder.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).toInstance((Object)this.mailboxManager)).build(), "lmtp.xml");
        }

        @Test
        void emailsShouldWellBeReceived() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            Username username = Username.of((String)"bob@examplebis.local");
            MailboxSession systemSession = this.mailboxManager.createSystemSession(username);
            Assertions.assertThatCode(() -> Assertions.assertThat((Long)((Long)Flux.from((Publisher)this.mailboxManager.getMailbox(MailboxPath.inbox((Username)username), systemSession).listMessagesMetadata(MessageRange.all(), systemSession)).count().block())).isEqualTo(1L)).doesNotThrowAnyException();
            Assertions.assertThat((String)IOUtils.toString((InputStream)((MessageResult)this.mailboxManager.getMailbox(MailboxPath.inbox((Username)username), systemSession).getMessages(MessageRange.all(), FetchGroup.FULL_CONTENT, systemSession).next()).getFullContent().getInputStream(), (Charset)StandardCharsets.UTF_8)).endsWith((CharSequence)"header:value\r\n\r\nbody\r\n");
        }

        @Test
        void dataShouldHaveAReturnCodePerRecipient() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <cedric@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            byte[] dataResponse = LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            Assertions.assertThat((String)new String(dataResponse, StandardCharsets.UTF_8)).contains(new CharSequence[]{"250 2.6.0 Message received <bob@examplebis.local>\r\n250 2.6.0 Message received <cedric@examplebis.local>"});
        }

        @Test
        void ehloShouldBeRejected() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("EHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            Assertions.assertThat((String)new String(LmtpServerTest.this.readBytes(server), StandardCharsets.UTF_8)).contains(new CharSequence[]{"500 Unable to process request: the command is unknown"});
        }

        @Test
        void heloShouldBeRejected() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("HELO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            Assertions.assertThat((String)new String(LmtpServerTest.this.readBytes(server), StandardCharsets.UTF_8)).contains(new CharSequence[]{"500 Unable to process request: the command is unknown"});
        }
    }

    @Nested
    class ThrowingOverQuotaExceptionTest {
        private InMemoryMailboxManager mailboxManager;

        ThrowingOverQuotaExceptionTest() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.mailboxManager = (InMemoryMailboxManager)Mockito.mock(InMemoryMailboxManager.class);
            LmtpServerTest.this.lmtpServerFactory = LmtpServerTest.this.createLMTPServer(LmtpServerTest.this.createMockProtocolHandlerLoaderBase().put(binder -> binder.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).toInstance((Object)this.mailboxManager)).build(), "lmtpnormaldsn.xml");
        }

        @Test
        void shouldHandleOverQuotaException() throws Exception {
            MessageManager messageManager = (MessageManager)Mockito.mock(MessageManager.class);
            MailboxSession mailboxSession = (MailboxSession)Mockito.mock(MailboxSession.class);
            Mockito.when((Object)this.mailboxManager.createSystemSession((Username)ArgumentMatchers.any(Username.class))).thenReturn((Object)mailboxSession);
            Mockito.when((Object)this.mailboxManager.mailboxExists((MailboxPath)ArgumentMatchers.any(), (MailboxSession)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)true));
            Mockito.when((Object)this.mailboxManager.getMailbox((MailboxPath)ArgumentMatchers.any(MailboxPath.class), (MailboxSession)ArgumentMatchers.any())).thenReturn((Object)messageManager);
            Mockito.when((Object)messageManager.appendMessage((MessageManager.AppendCommand)ArgumentMatchers.any(), (MailboxSession)ArgumentMatchers.any(MailboxSession.class))).thenThrow(new Throwable[]{new OverQuotaException("You have exceeded your quota", (QuotaLimitValue)QuotaCountLimit.count((long)0L), (QuotaUsageValue)QuotaCountUsage.count((long)0L))});
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <cedric@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            byte[] dataResponse = LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            Assertions.assertThat((String)new String(dataResponse, StandardCharsets.UTF_8)).contains(new CharSequence[]{"552 5.2.2 Over Quota error when delivering message to <bob@examplebis.local>\r\n552 5.2.2 Over Quota error when delivering message to <cedric@examplebis.local>"});
        }
    }

    @Nested
    class ThrowingTest {
        ThrowingTest() {
        }

        @BeforeEach
        void setUp() throws Exception {
            LmtpServerTest.this.lmtpServerFactory = LmtpServerTest.this.createLMTPServer(LmtpServerTest.this.createMockProtocolHandlerLoaderBase().put(binder -> binder.bind(MailProcessor.class).toInstance((Object)new ThrowingMailProcessor())).build(), "lmtpmailet.xml");
        }

        @Test
        void emailShouldTriggerTheMailProcessing() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            byte[] dataResponse = LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            Assertions.assertThat((String)new String(dataResponse, StandardCharsets.UTF_8)).startsWith((CharSequence)"451 4.0.0 Temporary error deliver message");
        }

        @Test
        void dataShouldHaveAReturnCodePerRecipient() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <cedric@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            byte[] dataResponse = LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            Assertions.assertThat((String)new String(dataResponse, StandardCharsets.UTF_8)).contains(new CharSequence[]{"451 4.0.0 Temporary error deliver message <bob@examplebis.local>\r\n451 4.0.0 Temporary error deliver message <cedric@examplebis.local>"});
        }
    }

    @Nested
    class NormalDSNTest {
        private InMemoryMailboxManager mailboxManager;

        NormalDSNTest() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.mailboxManager = InMemoryIntegrationResources.defaultResources().getMailboxManager();
            LmtpServerTest.this.lmtpServerFactory = LmtpServerTest.this.createLMTPServer(LmtpServerTest.this.createMockProtocolHandlerLoaderBase().put(binder -> binder.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).toInstance((Object)this.mailboxManager)).build(), "lmtpnormaldsn.xml");
        }

        @Test
        void dsnMessagesShouldBeWellReceived() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld> RET=HDRS ENVID=QQ314159\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local> NOTIFY=SUCCESS,FAILURE,DELAY ORCPT=rfc822;orcpt1@localhost\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            Username username = Username.of((String)"bob@examplebis.local");
            MailboxSession systemSession = this.mailboxManager.createSystemSession(username);
            Assertions.assertThatCode(() -> Assertions.assertThat((Long)((Long)Flux.from((Publisher)this.mailboxManager.getMailbox(MailboxPath.inbox((Username)username), systemSession).listMessagesMetadata(MessageRange.all(), systemSession)).count().block())).isEqualTo(1L)).doesNotThrowAnyException();
        }
    }

    @Nested
    class DSNTest {
        private RecordingMailProcessor recordingMailProcessor;

        DSNTest() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.recordingMailProcessor = new RecordingMailProcessor();
            LmtpServerTest.this.lmtpServerFactory = LmtpServerTest.this.createLMTPServer(LmtpServerTest.this.createMockProtocolHandlerLoaderBase().put(binder -> binder.bind(MailProcessor.class).toInstance((Object)this.recordingMailProcessor)).build(), "lmtpdsn.xml");
        }

        @Test
        void emailShouldTriggerTheMailProcessing() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld> RET=HDRS ENVID=QQ314159\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local> NOTIFY=SUCCESS,FAILURE,DELAY ORCPT=rfc822;orcpt1@localhost\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            ((ObjectAssert)Assertions.assertThat(this.recordingMailProcessor.getMails()).first()).extracting(Mail::dsnParameters).satisfies(new Consumer[]{Throwing.consumer(maybeDSN -> Assertions.assertThat((Optional)maybeDSN).isEqualTo((Object)DsnParameters.builder().envId(DsnParameters.EnvId.of((String)"QQ314159")).ret(DsnParameters.Ret.HDRS).addRcptParameter(new MailAddress("bob@examplebis.local"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.SUCCESS, DsnParameters.Notify.FAILURE, DsnParameters.Notify.DELAY), (MailAddress)new MailAddress("orcpt1@localhost"))).build()))});
        }

        @Test
        void lhloShouldAdvertizeDSN() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            Assertions.assertThat((String)new String(LmtpServerTest.this.readBytes(server), StandardCharsets.UTF_8)).contains(new CharSequence[]{"250 DSN\r\n"});
        }
    }

    @Nested
    class MailetContainerTest {
        private RecordingMailProcessor recordingMailProcessor;

        MailetContainerTest() {
        }

        @BeforeEach
        void setUp() throws Exception {
            this.recordingMailProcessor = new RecordingMailProcessor();
            LmtpServerTest.this.lmtpServerFactory = LmtpServerTest.this.createLMTPServer(LmtpServerTest.this.createMockProtocolHandlerLoaderBase().put(binder -> binder.bind(MailProcessor.class).toInstance((Object)this.recordingMailProcessor)).build(), "lmtpmailet.xml");
        }

        @Test
        void emailShouldTriggerTheMailProcessing() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            Assertions.assertThat(this.recordingMailProcessor.getMails()).hasSize(1);
        }

        @Test
        void dataShouldHaveAReturnCodePerRecipient() throws Exception {
            SocketChannel server = SocketChannel.open();
            server.connect(new InetSocketAddress("127.0.0.1", LmtpServerTest.getLmtpPort(LmtpServerTest.this.lmtpServerFactory)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("LHLO domain.tld\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("MAIL FROM: <bob@domain.tld>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <bob@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("RCPT TO: <cedric@examplebis.local>\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("DATA\r\n".getBytes(StandardCharsets.UTF_8)));
            LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("header:value\r\n\r\nbody".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap(".".getBytes(StandardCharsets.UTF_8)));
            server.write(ByteBuffer.wrap("\r\n".getBytes(StandardCharsets.UTF_8)));
            byte[] dataResponse = LmtpServerTest.this.readBytes(server);
            server.write(ByteBuffer.wrap("QUIT\r\n".getBytes(StandardCharsets.UTF_8)));
            Assertions.assertThat((String)new String(dataResponse, StandardCharsets.UTF_8)).contains(new CharSequence[]{"250 2.6.0 Message received <bob@examplebis.local>\r\n250 2.6.0 Message received <cedric@examplebis.local>"});
        }
    }

    static class ThrowingMailProcessor
    implements MailProcessor {
        ThrowingMailProcessor() {
        }

        public void service(Mail mail) {
            throw new RuntimeException("Oups");
        }
    }

    static class RecordingMailProcessor
    implements MailProcessor {
        private final ArrayList<Mail> mails = new ArrayList();

        RecordingMailProcessor() {
        }

        public void service(Mail mail) {
            this.mails.add(mail);
        }

        public List<Mail> getMails() {
            return this.mails;
        }
    }
}

