/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.mock;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;

public class MockProtocolHandlerLoader
implements ProtocolHandlerLoader {
    private final Injector injector;
    private final List<Object> loaderRegistry = new ArrayList<Object>();

    public static Builder builder() {
        return new Builder();
    }

    private MockProtocolHandlerLoader(Injector injector) {
        this.injector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolHandler load(String name, Configuration config) throws ProtocolHandlerLoader.LoadingException {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(name);
            ProtocolHandler obj = (ProtocolHandler)this.injector.getInstance(aClass);
            this.postConstruct(obj);
            this.init(obj, config);
            MockProtocolHandlerLoader mockProtocolHandlerLoader = this;
            synchronized (mockProtocolHandlerLoader) {
                this.loaderRegistry.add(obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new ProtocolHandlerLoader.LoadingException("Unable to load protocolhandler", (Throwable)e);
        }
    }

    public synchronized void dispose() {
        for (Object aLoaderRegistry : this.loaderRegistry) {
            try {
                this.preDestroy(aLoaderRegistry);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.loaderRegistry.clear();
    }

    private void postConstruct(Object resource) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        for (Method method : methods = resource.getClass().getMethods()) {
            PostConstruct postConstructAnnotation = method.getAnnotation(PostConstruct.class);
            if (postConstructAnnotation == null) continue;
            Object[] args = new Object[]{};
            method.invoke(resource, args);
        }
    }

    private void preDestroy(Object resource) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        for (Method method : methods = resource.getClass().getMethods()) {
            PreDestroy preDestroyAnnotation = method.getAnnotation(PreDestroy.class);
            if (preDestroyAnnotation == null) continue;
            Object[] args = new Object[]{};
            method.invoke(resource, args);
        }
    }

    private void init(Object resource, Configuration config) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        for (Method method : methods = resource.getClass().getMethods()) {
            if (!this.isInit(method)) continue;
            Object[] args = new Object[]{config};
            method.invoke(resource, args);
        }
    }

    private boolean isInit(Method method) {
        return method.getName().equals("init") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Configuration.class);
    }

    public static class Builder {
        private final ImmutableList.Builder<Module> modules = ImmutableList.builder();

        private Builder() {
        }

        public <T, U extends T> Builder put(Module module) {
            this.modules.add((Object)module);
            return this;
        }

        public MockProtocolHandlerLoader build() {
            return new MockProtocolHandlerLoader(Guice.createInjector((Iterable)this.modules.build()));
        }
    }
}

