/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib;

import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.protocols.api.ClientAuth;
import org.apache.james.protocols.lib.mock.ConfigLoader;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.Encryption;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AbstractConfigurableAsyncServerTest {
    private MemoryFileSystem memoryFileSystem;
    private TestableConfigurableAsyncServer testServer;

    AbstractConfigurableAsyncServerTest() {
    }

    private void initTestServer(String configFile) throws Exception {
        this.testServer = new TestableConfigurableAsyncServer();
        this.testServer.setFileSystem(this.memoryFileSystem);
        this.testServer.configure((HierarchicalConfiguration)ConfigLoader.getConfig(ClassLoader.getSystemResourceAsStream(configFile)));
    }

    @BeforeEach
    void setUp() {
        this.memoryFileSystem = new MemoryFileSystem();
    }

    @Test
    void testServerDisabled() throws Exception {
        this.initTestServer("testServerDisabled.xml");
        Assertions.assertThat((boolean)this.testServer.isEnabled()).isFalse();
    }

    @Test
    void testEmpty() throws Exception {
        this.initTestServer("testServerDefaults.xml");
        Assertions.assertThat((boolean)this.testServer.isEnabled()).isTrue();
        Assertions.assertThat((String)this.testServer.getJmxName()).isEqualTo(this.testServer.getDefaultJMXName());
        Assertions.assertThat((String)this.testServer.getHelloName()).isEqualTo(AbstractConfigurableAsyncServerTest.getLocalHostName());
        Assertions.assertThat((int)this.testServer.getTimeout()).isEqualTo(300);
        Assertions.assertThat((int)this.testServer.getBacklog()).isEqualTo(200);
        Assertions.assertThat((int)this.testServer.getMaximumConcurrentConnections()).isZero();
        Assertions.assertThat((int)this.testServer.getConnPerIp()).isZero();
        this.testServer.buildSSLContext();
        Assertions.assertThat((Object)this.testServer.getEncryption()).isNull();
    }

    @Test
    void testServerPlain() throws Exception {
        this.initTestServer("testServerPlain.xml");
        Assertions.assertThat((boolean)this.testServer.isEnabled()).isTrue();
        Assertions.assertThat((String)this.testServer.getJmxName()).isEqualTo("testserver-custom");
        Assertions.assertThat((String)this.testServer.getHelloName()).isEqualTo("custom-mailer");
        Assertions.assertThat((int)this.testServer.getTimeout()).isEqualTo(360);
        Assertions.assertThat((int)this.testServer.getBacklog()).isEqualTo(150);
        Assertions.assertThat((int)this.testServer.getMaximumConcurrentConnections()).isEqualTo(100);
        Assertions.assertThat((int)this.testServer.getConnPerIp()).isEqualTo(5);
        this.testServer.buildSSLContext();
        Assertions.assertThat((Object)this.testServer.getEncryption()).isNull();
    }

    @Test
    void testServerTLS() throws Exception {
        this.memoryFileSystem.put("file://conf/keystore", "keystore");
        this.initTestServer("testServerTLS.xml");
        this.testServer.buildSSLContext();
        Assertions.assertThat((Object)this.testServer.getEncryption()).isNotNull();
        Assertions.assertThat((boolean)this.testServer.getEncryption().isStartTLS()).isFalse();
        Assertions.assertThat((Object[])this.testServer.getEncryption().getEnabledCipherSuites()).isEmpty();
        Assertions.assertThat((Comparable)this.testServer.getEncryption().getClientAuth()).isEqualTo((Object)ClientAuth.NONE);
        Assertions.assertThat((boolean)this.testServer.getEncryption().supportsEncryption()).isTrue();
    }

    @Test
    void testServerStartTLS() throws Exception {
        this.memoryFileSystem.put("file://conf/keystore", "keystore");
        this.initTestServer("testServerStartTLS.xml");
        this.testServer.buildSSLContext();
        Assertions.assertThat((Object)this.testServer.getEncryption()).isNotNull();
        Assertions.assertThat((boolean)this.testServer.getEncryption().isStartTLS()).isTrue();
        Assertions.assertThat((Object[])this.testServer.getEncryption().getEnabledCipherSuites()).isEmpty();
        Assertions.assertThat((Comparable)this.testServer.getEncryption().getClientAuth()).isEqualTo((Object)ClientAuth.NONE);
        Assertions.assertThat((boolean)this.testServer.getEncryption().supportsEncryption()).isTrue();
    }

    @Test
    void testServerTLSNeedClientAuth() throws Exception {
        this.memoryFileSystem.put("file://conf/keystore", "keystore");
        this.memoryFileSystem.put("file://conf/truststore", "keystore");
        this.initTestServer("testServerTLSNeedAuth.xml");
        this.testServer.buildSSLContext();
        Assertions.assertThat((Object)this.testServer.getEncryption()).isNotNull();
        Assertions.assertThat((Comparable)this.testServer.getEncryption().getClientAuth()).isNotNull();
        Assertions.assertThat((Comparable)this.testServer.getEncryption().getClientAuth()).isEqualTo((Object)ClientAuth.NEED);
    }

    @Test
    void testServerTLSDefaultClientAuth() throws Exception {
        this.memoryFileSystem.put("file://conf/keystore", "keystore");
        this.initTestServer("testServerTLSDefaultAuth.xml");
        this.testServer.buildSSLContext();
        Assertions.assertThat((Object)this.testServer.getEncryption()).isNotNull();
        Assertions.assertThat((Comparable)this.testServer.getEncryption().getClientAuth()).isNotNull();
        Assertions.assertThat((Comparable)this.testServer.getEncryption().getClientAuth()).isEqualTo((Object)ClientAuth.NEED);
    }

    private static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ue) {
            return "localhost";
        }
    }

    private static class TestableConfigurableAsyncServer
    extends AbstractConfigurableAsyncServer {
        private TestableConfigurableAsyncServer() {
        }

        public String getServiceType() {
            return "Test Service";
        }

        protected int getDefaultPort() {
            return 12345;
        }

        protected String getDefaultJMXName() {
            return "testserver";
        }

        protected ChannelHandlerFactory createFrameHandlerFactory() {
            return null;
        }

        protected ChannelInboundHandlerAdapter createCoreHandler() {
            return null;
        }

        public int getConnPerIp() {
            return this.connPerIP;
        }

        public String getJmxName() {
            return this.jmxName;
        }

        public Encryption getEncryption() {
            return this.encryption;
        }

        public void buildSSLContext() throws Exception {
            super.buildSSLContext();
        }
    }

    private static class MemoryFileSystem
    implements FileSystem {
        private final Map<String, String> fileResources = new HashMap<String, String>();

        private MemoryFileSystem() {
        }

        public InputStream getResource(String url) throws IOException {
            InputStream resourceStream;
            String resourceName = this.fileResources.get(url);
            if (resourceName != null && (resourceStream = ClassLoader.getSystemResourceAsStream(resourceName)) != null) {
                return resourceStream;
            }
            throw new FileNotFoundException(url);
        }

        public File getFile(String fileURL) throws FileNotFoundException {
            URL resource;
            String resourceName = this.fileResources.get(fileURL);
            if (resourceName != null && (resource = ClassLoader.getSystemResource(resourceName)) != null) {
                return new File(resource.getPath());
            }
            throw new FileNotFoundException(fileURL);
        }

        public File getBasedir() {
            throw new NotImplementedException("getBasedir");
        }

        public void put(String fileUrl, String resourceName) {
            this.fileResources.put(fileUrl, resourceName);
        }
    }
}

