/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import java.util.List;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.Scenario;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreFactory;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepository;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryKeysDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoV2;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryModule;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraMailRepositoryWithFakeImplementationsTest {
    @RegisterExtension
    static CassandraClusterExtension extension = new CassandraClusterExtension(CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraMailRepositoryModule.MODULE, CassandraBlobModule.MODULE, CassandraSchemaVersionModule.MODULE}));
    private static final MailRepositoryUrl URL = MailRepositoryUrl.from((String)"proto://url");
    private static final HashBlobId.Factory BLOB_ID_FACTORY = new HashBlobId.Factory();
    CassandraMailRepository cassandraMailRepository;
    CassandraMailRepositoryKeysDAO keysDAO;

    CassandraMailRepositoryWithFakeImplementationsTest() {
    }

    @BeforeEach
    void setup(CassandraCluster cassandra) {
        CassandraMailRepositoryMailDaoV2 mailDAO = new CassandraMailRepositoryMailDaoV2((CqlSession)cassandra.getConf(), (BlobId.Factory)BLOB_ID_FACTORY);
        this.keysDAO = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.DEFAULT_CONFIGURATION);
        BlobStore blobStore = CassandraBlobStoreFactory.forTesting((CqlSession)cassandra.getConf(), (MetricFactory)new RecordingMetricFactory()).passthrough();
        this.cassandraMailRepository = new CassandraMailRepository(URL, this.keysDAO, mailDAO, MimeMessageStore.factory((BlobStore)blobStore));
    }

    @Nested
    class FailingKeysDaoTest {
        FailingKeysDaoTest() {
        }

        @Test
        void sizeShouldNotBeIncreasedWhenStoringKeysHasFailed(CassandraCluster cassandra) throws Exception {
            cassandra.getConf().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO mailrepositorykeys")});
            MailImpl mail = MailImpl.builder().name("mymail").sender("sender@localhost").addRecipient("rec1@domain.com").addRecipient("rec2@domain.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("this is the content").build()).build();
            Assertions.assertThatThrownBy(() -> CassandraMailRepositoryWithFakeImplementationsTest.this.cassandraMailRepository.store((Mail)mail)).isInstanceOf(RuntimeException.class);
            Assertions.assertThat((Long)((Long)CassandraMailRepositoryWithFakeImplementationsTest.this.keysDAO.getCount(URL).block())).isEqualTo(0L);
        }

        @Test
        void mimeMessageShouldBeStoredWhenStoringKeysHasFailed(CassandraCluster cassandra) throws Exception {
            cassandra.getConf().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO mailrepositorykeys")});
            MailImpl mail = MailImpl.builder().name("mymail").sender("sender@localhost").addRecipient("rec1@domain.com").addRecipient("rec2@domain.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("this is the content").build()).build();
            Assertions.assertThatThrownBy(() -> CassandraMailRepositoryWithFakeImplementationsTest.this.cassandraMailRepository.store((Mail)mail)).isInstanceOf(RuntimeException.class);
            ResultSet resultSet = cassandra.getConf().execute((Statement)QueryBuilder.selectFrom((String)"blobs").all().build());
            Assertions.assertThat((List)resultSet.all()).hasSize(2);
        }

        @Test
        void mailPartsShouldBeStoredWhenStoringKeysHasFailed(CassandraCluster cassandra) throws Exception {
            cassandra.getConf().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO mailrepositorykeys")});
            MailImpl mail = MailImpl.builder().name("mymail").sender("sender@localhost").addRecipient("rec1@domain.com").addRecipient("rec2@domain.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("this is the content").build()).build();
            Assertions.assertThatThrownBy(() -> CassandraMailRepositoryWithFakeImplementationsTest.this.cassandraMailRepository.store((Mail)mail)).isInstanceOf(RuntimeException.class);
            ResultSet resultSet = cassandra.getConf().execute((Statement)QueryBuilder.selectFrom((String)"mailRepositoryContentV2").all().build());
            Assertions.assertThat((List)resultSet.all()).hasSize(1);
        }
    }

    @Nested
    class FailingMailDaoTest {
        FailingMailDaoTest() {
        }

        @Test
        void keysShouldNotBeStoredWhenStoringMailPartsHasFailed(CassandraCluster cassandra) throws Exception {
            cassandra.getConf().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO mailrepositorycontent")});
            MailImpl mail = MailImpl.builder().name("mymail").sender("sender@localhost").addRecipient("rec1@domain.com").addRecipient("rec2@domain.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("this is the content").build()).build();
            Assertions.assertThatThrownBy(() -> CassandraMailRepositoryWithFakeImplementationsTest.this.cassandraMailRepository.store((Mail)mail)).isInstanceOf(RuntimeException.class);
            Assertions.assertThat((List)((List)CassandraMailRepositoryWithFakeImplementationsTest.this.keysDAO.list(URL).collectList().block())).isEmpty();
        }

        @Test
        void mimeMessageShouldBeStoredWhenStoringMailPartsHasFailed(CassandraCluster cassandra) throws Exception {
            cassandra.getConf().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO mailrepositorycontent")});
            MailImpl mail = MailImpl.builder().name("mymail").sender("sender@localhost").addRecipient("rec1@domain.com").addRecipient("rec2@domain.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("this is the content").build()).build();
            Assertions.assertThatThrownBy(() -> CassandraMailRepositoryWithFakeImplementationsTest.this.cassandraMailRepository.store((Mail)mail)).isInstanceOf(RuntimeException.class);
            ResultSet resultSet = cassandra.getConf().execute((Statement)QueryBuilder.selectFrom((String)"blobs").all().build());
            Assertions.assertThat((List)resultSet.all()).hasSize(2);
        }
    }

    @Nested
    class FailingStoreTest {
        FailingStoreTest() {
        }

        @Test
        void keysShouldNotBeStoredWhenStoringMimeMessageHasFailed(CassandraCluster cassandra) throws Exception {
            cassandra.getConf().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO blobparts")});
            MailImpl mail = MailImpl.builder().name("mymail").sender("sender@localhost").addRecipient("rec1@domain.com").addRecipient("rec2@domain.com").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("test").setText("this is the content").build()).build();
            Assertions.assertThatThrownBy(() -> CassandraMailRepositoryWithFakeImplementationsTest.this.cassandraMailRepository.store((Mail)mail)).isInstanceOf(RuntimeException.class);
            Assertions.assertThat((List)((List)CassandraMailRepositoryWithFakeImplementationsTest.this.keysDAO.list(URL).collectList().block())).isEmpty();
        }
    }
}

