/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryUrlModule;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryUrlStore;
import org.apache.james.mailrepository.cassandra.UrlsDao;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class CassandraMailRepositoryUrlStoreExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
AfterEachCallback {
    private final CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraMailRepositoryUrlModule.MODULE);

    public void beforeAll(ExtensionContext context) {
        this.cassandraCluster.beforeAll(context);
    }

    public void afterEach(ExtensionContext context) {
        this.cassandraCluster.afterEach(context);
    }

    public void afterAll(ExtensionContext context) {
        this.cassandraCluster.afterAll(context);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == MailRepositoryUrlStore.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return new CassandraMailRepositoryUrlStore(new UrlsDao((CqlSession)this.cassandraCluster.getCassandraCluster().getConf()));
    }
}

