/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreFactory;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.mailrepository.MailRepositoryContract;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.cassandra.CassandraMailRepository;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryKeysDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoV2;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryModule;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraMailRepositoryTest {
    static final MailRepositoryUrl URL = MailRepositoryUrl.from((String)"proto://url");
    static final HashBlobId.Factory BLOB_ID_FACTORY = new HashBlobId.Factory();
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraSchemaVersionModule.MODULE, CassandraMailRepositoryModule.MODULE, CassandraBlobModule.MODULE}));
    CassandraMailRepository cassandraMailRepository;

    CassandraMailRepositoryTest() {
    }

    @Nested
    class DeDuplicationTest
    implements MailRepositoryContract {
        DeDuplicationTest() {
        }

        @BeforeEach
        void setup(CassandraCluster cassandra) {
            CassandraMailRepositoryMailDaoV2 v2 = new CassandraMailRepositoryMailDaoV2((CqlSession)cassandra.getConf(), (BlobId.Factory)BLOB_ID_FACTORY);
            CassandraMailRepositoryKeysDAO keysDAO = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.DEFAULT_CONFIGURATION);
            BlobStore blobStore = CassandraBlobStoreFactory.forTesting((CqlSession)cassandra.getConf(), (MetricFactory)new RecordingMetricFactory()).deduplication();
            CassandraMailRepositoryTest.this.cassandraMailRepository = new CassandraMailRepository(URL, keysDAO, v2, MimeMessageStore.factory((BlobStore)blobStore));
        }

        public MailRepository retrieveRepository(MailRepositoryPath url) {
            CassandraCluster cassandra = cassandraCluster.getCassandraCluster();
            CassandraMailRepositoryMailDaoV2 v2 = new CassandraMailRepositoryMailDaoV2((CqlSession)cassandra.getConf(), (BlobId.Factory)BLOB_ID_FACTORY);
            CassandraMailRepositoryKeysDAO keysDAO = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.DEFAULT_CONFIGURATION);
            BlobStore blobStore = CassandraBlobStoreFactory.forTesting((CqlSession)cassandra.getConf(), (MetricFactory)new RecordingMetricFactory()).deduplication();
            return new CassandraMailRepository(MailRepositoryUrl.fromPathAndProtocol((Protocol)new Protocol("cassandra"), (MailRepositoryPath)url), keysDAO, v2, MimeMessageStore.factory((BlobStore)blobStore));
        }

        public MailRepository retrieveRepository() {
            return CassandraMailRepositoryTest.this.cassandraMailRepository;
        }

        @Test
        @Disabled(value="key is unique in Cassandra")
        public void sizeShouldBeIncrementedByOneWhenDuplicates() {
        }

        @Test
        @Disabled(value="depend on setting turn on/off lightweight transaction")
        public void storeShouldHaveNoEffectOnSizeWhenAlreadyStoredMail() {
        }

        @Test
        @Disabled(value="depend on setting turn on/off lightweight transaction")
        public void removeShouldHaveNoEffectOnSizeWhenUnknownKeys() {
        }

        @Test
        void removeShouldNotAffectMailsWithTheSameContent() throws Exception {
            MailRepository testee = this.retrieveRepository();
            MailKey key1 = testee.store((Mail)this.createMail(MAIL_1));
            MailKey key2 = testee.store((Mail)this.createMail(MAIL_2));
            testee.remove(key1);
            Assertions.assertThatCode(() -> testee.retrieve(key2)).doesNotThrowAnyException();
        }
    }

    @Nested
    class PassThroughTest
    implements MailRepositoryContract {
        PassThroughTest() {
        }

        @BeforeEach
        void setup(CassandraCluster cassandra) {
            CassandraMailRepositoryMailDaoV2 v2 = new CassandraMailRepositoryMailDaoV2((CqlSession)cassandra.getConf(), (BlobId.Factory)BLOB_ID_FACTORY);
            CassandraMailRepositoryKeysDAO keysDAO = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.DEFAULT_CONFIGURATION);
            BlobStore blobStore = CassandraBlobStoreFactory.forTesting((CqlSession)cassandra.getConf(), (MetricFactory)new RecordingMetricFactory()).passthrough();
            CassandraMailRepositoryTest.this.cassandraMailRepository = new CassandraMailRepository(URL, keysDAO, v2, MimeMessageStore.factory((BlobStore)blobStore));
        }

        public MailRepository retrieveRepository(MailRepositoryPath url) {
            CassandraCluster cassandra = cassandraCluster.getCassandraCluster();
            CassandraMailRepositoryMailDaoV2 v2 = new CassandraMailRepositoryMailDaoV2((CqlSession)cassandra.getConf(), (BlobId.Factory)BLOB_ID_FACTORY);
            CassandraMailRepositoryKeysDAO keysDAO = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.DEFAULT_CONFIGURATION);
            BlobStore blobStore = CassandraBlobStoreFactory.forTesting((CqlSession)cassandra.getConf(), (MetricFactory)new RecordingMetricFactory()).passthrough();
            return new CassandraMailRepository(MailRepositoryUrl.fromPathAndProtocol((Protocol)new Protocol("cassandra"), (MailRepositoryPath)url), keysDAO, v2, MimeMessageStore.factory((BlobStore)blobStore));
        }

        public MailRepository retrieveRepository() {
            return CassandraMailRepositoryTest.this.cassandraMailRepository;
        }

        @Test
        @Disabled(value="key is unique in Cassandra")
        public void sizeShouldBeIncrementedByOneWhenDuplicates() {
        }

        @Test
        @Disabled(value="depend on setting turn on/off lightweight transaction")
        public void storeShouldHaveNoEffectOnSizeWhenAlreadyStoredMail() {
        }

        @Test
        @Disabled(value="depend on setting turn on/off lightweight transaction")
        public void removeShouldHaveNoEffectOnSizeWhenUnknownKeys() {
        }

        @Test
        void removeShouldDeleteStoredBlobs(CassandraCluster cassandra) throws Exception {
            MailRepository testee = this.retrieveRepository();
            MailKey key1 = testee.store((Mail)this.createMail(MAIL_1));
            testee.remove(key1);
            Assertions.assertThat((Iterable)cassandra.getConf().execute((Statement)QueryBuilder.selectFrom((String)"blobs").all().build())).isEmpty();
        }
    }
}

