/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.TestBlobId;
import org.apache.james.core.MailAddress;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryKeysDAOTest;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoV2;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryModule;
import org.apache.james.mailrepository.cassandra.MailRepositoryBlobReferenceSource;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraMailRepositoryMailDAOTest {
    static final MailRepositoryUrl URL = MailRepositoryUrl.from((String)"proto://url");
    static final MailKey KEY_1 = new MailKey("key1");
    static final TestBlobId.Factory BLOB_ID_FACTORY = new TestBlobId.Factory();
    public static final CassandraModule MODULE = CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraMailRepositoryModule.MODULE, CassandraSchemaVersionModule.MODULE});
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(MODULE);
    private CassandraMailRepositoryMailDaoV2 testee;
    private MailRepositoryBlobReferenceSource blobReferenceSource;

    CassandraMailRepositoryMailDAOTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.testee = new CassandraMailRepositoryMailDaoV2((CqlSession)cassandra.getConf(), (BlobId.Factory)BLOB_ID_FACTORY);
        this.blobReferenceSource = new MailRepositoryBlobReferenceSource(this.testee);
    }

    @Test
    void storeShouldAcceptMailWithOnlyName() throws Exception {
        BlobId blobIdBody = BLOB_ID_FACTORY.from("blobHeader");
        BlobId blobIdHeader = BLOB_ID_FACTORY.from("blobBody");
        this.testee.store(URL, (Mail)FakeMail.builder().name(KEY_1.asString()).build(), blobIdHeader, blobIdBody).block();
        CassandraMailRepositoryMailDaoV2.MailDTO mailDTO = (CassandraMailRepositoryMailDaoV2.MailDTO)((Optional)this.testee.read(URL, KEY_1).block()).get();
        MailImpl partialMail = mailDTO.getMailBuilder().build();
        SoftAssertions.assertSoftly(arg_0 -> CassandraMailRepositoryMailDAOTest.lambda$storeShouldAcceptMailWithOnlyName$0(mailDTO, blobIdBody, blobIdHeader, (Mail)partialMail, arg_0));
    }

    @Test
    void removeShouldDeleteMailMetaData() throws Exception {
        BlobId blobIdBody = BLOB_ID_FACTORY.from("blobHeader");
        BlobId blobIdHeader = BLOB_ID_FACTORY.from("blobBody");
        this.testee.store(URL, (Mail)FakeMail.builder().name(KEY_1.asString()).build(), blobIdHeader, blobIdBody).block();
        this.testee.remove(URL, KEY_1).block();
        Assertions.assertThat((Optional)((Optional)this.testee.read(URL, KEY_1).block())).isEmpty();
    }

    @Test
    void readShouldReturnEmptyWhenAbsent() {
        Assertions.assertThat((Optional)((Optional)this.testee.read(URL, KEY_1).block())).isEmpty();
    }

    @Test
    void readShouldReturnAllMailMetadata() throws Exception {
        BlobId blobIdBody = BLOB_ID_FACTORY.from("blobHeader");
        BlobId blobIdHeader = BLOB_ID_FACTORY.from("blobBody");
        String errorMessage = "error message";
        String state = "state";
        String remoteAddr = "remoteAddr";
        String remoteHost = "remoteHost";
        PerRecipientHeaders.Header header = PerRecipientHeaders.Header.builder().name("headerName").value("headerValue").build();
        AttributeName attributeName = AttributeName.of((String)"att1");
        ImmutableList attributeValue = ImmutableList.of((Object)AttributeValue.of((String)"value1"), (Object)AttributeValue.of((String)"value2"));
        Attribute attribute = new Attribute(attributeName, AttributeValue.of((Collection)attributeValue));
        ImmutableList attributes = ImmutableList.of((Object)attribute);
        this.testee.store(URL, (Mail)FakeMail.builder().name(KEY_1.asString()).sender(MailAddressFixture.SENDER).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).errorMessage(errorMessage).state(state).remoteAddr(remoteAddr).remoteHost(remoteHost).addHeaderForRecipient(header, MailAddressFixture.RECIPIENT1).attributes((Collection)attributes).build(), blobIdHeader, blobIdBody).block();
        CassandraMailRepositoryMailDaoV2.MailDTO mailDTO = (CassandraMailRepositoryMailDaoV2.MailDTO)((Optional)this.testee.read(URL, KEY_1).block()).get();
        MailImpl partialMail = mailDTO.getMailBuilder().build();
        SoftAssertions.assertSoftly(arg_0 -> CassandraMailRepositoryMailDAOTest.lambda$readShouldReturnAllMailMetadata$1(mailDTO, blobIdBody, blobIdHeader, (Mail)partialMail, errorMessage, state, remoteAddr, remoteHost, attributeName, attribute, header, arg_0));
    }

    @Test
    void blobReferencesShouldBeEmptyByDefault() {
        Assertions.assertThat((List)((List)this.blobReferenceSource.listReferencedBlobs().collectList().block())).isEmpty();
    }

    @Test
    void blobReferencesShouldAllAddedValues() throws Exception {
        BlobId blobIdBody = BLOB_ID_FACTORY.from("blobHeader");
        BlobId blobIdHeader = BLOB_ID_FACTORY.from("blobBody");
        String state = "state";
        AttributeName attributeName = AttributeName.of((String)"att1");
        ImmutableList attributeValue = ImmutableList.of((Object)AttributeValue.of((String)"value1"), (Object)AttributeValue.of((String)"value2"));
        Attribute attribute = new Attribute(attributeName, AttributeValue.of((Collection)attributeValue));
        ImmutableList attributes = ImmutableList.of((Object)attribute);
        this.testee.store(URL, (Mail)FakeMail.builder().name(KEY_1.asString()).sender(MailAddressFixture.SENDER).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).state(state).attributes((Collection)attributes).build(), blobIdHeader, blobIdBody).block();
        BlobId blobIdBody2 = BLOB_ID_FACTORY.from("blobHeader2");
        BlobId blobIdHeader2 = BLOB_ID_FACTORY.from("blobBody2");
        this.testee.store(URL, (Mail)FakeMail.builder().name(CassandraMailRepositoryKeysDAOTest.KEY_2.asString()).sender(MailAddressFixture.SENDER).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).state(state).attributes((Collection)attributes).build(), blobIdHeader2, blobIdBody2).block();
        Assertions.assertThat((List)((List)this.blobReferenceSource.listReferencedBlobs().collectList().block())).containsOnly((Object[])new BlobId[]{blobIdBody, blobIdBody2, blobIdHeader, blobIdHeader2});
    }

    private static /* synthetic */ void lambda$readShouldReturnAllMailMetadata$1(CassandraMailRepositoryMailDaoV2.MailDTO mailDTO, BlobId blobIdBody, BlobId blobIdHeader, Mail partialMail, String errorMessage, String state, String remoteAddr, String remoteHost, AttributeName attributeName, Attribute attribute, PerRecipientHeaders.Header header, SoftAssertions softly) {
        softly.assertThat((Object)mailDTO.getBodyBlobId()).isEqualTo((Object)blobIdBody);
        softly.assertThat((Object)mailDTO.getHeaderBlobId()).isEqualTo((Object)blobIdHeader);
        softly.assertThat(partialMail.getName()).isEqualTo(KEY_1.asString());
        softly.assertThat(partialMail.getErrorMessage()).isEqualTo(errorMessage);
        softly.assertThat(partialMail.getState()).isEqualTo(state);
        softly.assertThat(partialMail.getRemoteAddr()).isEqualTo(remoteAddr);
        softly.assertThat(partialMail.getRemoteHost()).isEqualTo(remoteHost);
        softly.assertThat(partialMail.attributeNames()).containsOnly((Object[])new AttributeName[]{attributeName});
        softly.assertThat(partialMail.getAttribute(attributeName)).contains((Object)attribute);
        softly.assertThat(partialMail.getPerRecipientSpecificHeaders().getRecipientsWithSpecificHeaders()).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1});
        softly.assertThat(partialMail.getPerRecipientSpecificHeaders().getHeadersForRecipient(MailAddressFixture.RECIPIENT1)).containsOnly((Object[])new PerRecipientHeaders.Header[]{header});
        softly.assertThat(partialMail.getMaybeSender().asOptional()).contains((Object)MailAddressFixture.SENDER);
        softly.assertThat(partialMail.getRecipients()).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2});
    }

    private static /* synthetic */ void lambda$storeShouldAcceptMailWithOnlyName$0(CassandraMailRepositoryMailDaoV2.MailDTO mailDTO, BlobId blobIdBody, BlobId blobIdHeader, Mail partialMail, SoftAssertions softly) {
        softly.assertThat((Object)mailDTO.getBodyBlobId()).isEqualTo((Object)blobIdBody);
        softly.assertThat((Object)mailDTO.getHeaderBlobId()).isEqualTo((Object)blobIdHeader);
        softly.assertThat(partialMail.getName()).isEqualTo(KEY_1.asString());
    }
}

