/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.List;
import java.util.Optional;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryKeysDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryModule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraMailRepositoryKeysDAOTest {
    static final MailRepositoryUrl URL = MailRepositoryUrl.from((String)"proto://url");
    static final MailRepositoryUrl URL2 = MailRepositoryUrl.from((String)"proto://url2");
    static final MailKey KEY_1 = new MailKey("key1");
    static final MailKey KEY_2 = new MailKey("key2");
    static final MailKey KEY_3 = new MailKey("key3");
    static final CassandraModule MODULE = CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraMailRepositoryModule.MODULE, CassandraSchemaVersionModule.MODULE});
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(MODULE);
    CassandraMailRepositoryKeysDAO testee;

    CassandraMailRepositoryKeysDAOTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.testee = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.DEFAULT_CONFIGURATION);
    }

    @Test
    void listShouldBeEmptyByDefault() {
        Assertions.assertThat((List)((List)this.testee.list(URL).collectList().block())).isEmpty();
    }

    @Test
    void listShouldReturnEmptyByDefault() {
        this.testee.store(URL, KEY_1).block();
        Assertions.assertThat((List)((List)this.testee.list(URL).collectList().block())).containsOnly((Object[])new MailKey[]{KEY_1});
    }

    @Test
    void listShouldNotReturnElementsOfOtherRepositories() {
        this.testee.store(URL, KEY_1).block();
        Assertions.assertThat((List)((List)this.testee.list(URL2).collectList().block())).isEmpty();
    }

    @Test
    void listShouldReturnSeveralElements() {
        this.testee.store(URL, KEY_1).block();
        this.testee.store(URL, KEY_2).block();
        this.testee.store(URL, KEY_3).block();
        Assertions.assertThat((List)((List)this.testee.list(URL).collectList().block())).containsOnly((Object[])new MailKey[]{KEY_1, KEY_2, KEY_3});
    }

    @Test
    void listShouldNotReturnRemovedElements() {
        this.testee.store(URL, KEY_1).block();
        this.testee.store(URL, KEY_2).block();
        this.testee.store(URL, KEY_3).block();
        this.testee.remove(URL, KEY_2).block();
        Assertions.assertThat((List)((List)this.testee.list(URL).collectList().block())).containsOnly((Object[])new MailKey[]{KEY_1, KEY_3});
    }

    @Test
    void removeShouldBeIdempotent() {
        this.testee.remove(URL, KEY_2).block();
    }

    @Test
    void removeShouldNotAffectOtherRepositories() {
        this.testee.store(URL, KEY_1).block();
        this.testee.remove(URL2, KEY_2).block();
        Assertions.assertThat((List)((List)this.testee.list(URL).collectList().block())).containsOnly((Object[])new MailKey[]{KEY_1});
    }

    @Test
    void removeShouldReturnTrueWhenKeyDeleted() {
        this.testee.store(URL, KEY_1).block();
        boolean isDeleted = (Boolean)this.testee.remove(URL, KEY_1).block();
        Assertions.assertThat((boolean)isDeleted).isTrue();
    }

    @Test
    void storeShouldReturnTrueWhenNotPreviouslyStored() {
        boolean isStored = (Boolean)this.testee.store(URL, KEY_1).block();
        Assertions.assertThat((boolean)isStored).isTrue();
    }

    @Nested
    class WhenStrongConsistencyIsTrue {
        CassandraMailRepositoryKeysDAO testee;

        WhenStrongConsistencyIsTrue() {
        }

        @BeforeEach
        void setUp(CassandraCluster cassandra) {
            this.testee = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.builder().mailRepositoryStrongConsistency(Optional.of(true)).build());
        }

        @Test
        void storeShouldReturnFalseWhenPreviouslyStored() {
            this.testee.store(URL, KEY_1).block();
            Assertions.assertThat((Boolean)((Boolean)this.testee.store(URL, KEY_1).block())).isFalse();
        }

        @Test
        void removeShouldReturnFalseWhenKeyNotDeleted() {
            Assertions.assertThat((Boolean)((Boolean)this.testee.remove(URL2, KEY_2).block())).isFalse();
        }
    }

    @Nested
    class WhenStrongConsistencyIsFalse {
        CassandraMailRepositoryKeysDAO testee;

        WhenStrongConsistencyIsFalse() {
        }

        @BeforeEach
        void setUp(CassandraCluster cassandra) {
            this.testee = new CassandraMailRepositoryKeysDAO((CqlSession)cassandra.getConf(), CassandraConfiguration.builder().mailRepositoryStrongConsistency(Optional.of(false)).build());
        }

        @Test
        void storeShouldReturnTrueWhenPreviouslyStored() {
            this.testee.store(URL, KEY_1).block();
            Assertions.assertThat((Boolean)((Boolean)this.testee.store(URL, KEY_1).block())).isTrue();
        }

        @Test
        void removeShouldReturnTrueWhenKeyNotDeleted() {
            Assertions.assertThat((Boolean)((Boolean)this.testee.remove(URL2, KEY_2).block())).isTrue();
        }
    }
}

