/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.apache.james.jdkim.MockPublicKeyRecordRetriever;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.mailets.DKIMVerify;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DKIMVerifyTest {
    @Test
    void testDKIMVerifyPass() throws Exception {
        String message = "DKIM-Signature: v=1; d=example.com; t=1284762805; b=ZFfwSIzTQM7k9syRnl9VfQh0/dr99euvBe1gn/DiTrnEZjxyjzQBD2MMvowVdbHpPMtSjtCtehU9zZ3urXmj5iHKujpEkP92FEKinzElkQ2eT2zoxdg1zByPHsKPX+KjrBespAJcO2k052aOK5kIBFxpQumP4aiW7ZklBKSWMBk=; s=selector; a=rsa-sha256; bh=rHOD7fd9xnNxK7OSl5ellpQVF14NNFbOIizqtUMhnio=; h=from:to:received:received;\r\nReceived: by 10.XX.XX.12 with SMTP id dfgskldjfhgkljsdfhgkljdhfg;\r\n\tTue, 06 Oct 2009 07:37:34 -0700 (PDT)\r\nReturn-Path: <bounce@example.com>\r\nReceived: from example.co.uk (example.co.uk [XX.XXX.125.19])\r\n\tby mx.example.com with ESMTP id dgdfgsdfgsd.97.2009.10.06.07.37.32;\r\n\tTue, 06 Oct 2009 07:37:32 -0700 (PDT)\r\nFrom: apache@bago.org\r\nTo: apache@bago.org\r\n\r\nbody\r\nprova\r\n";
        Mail mail = this.process(message);
        Optional attr = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)DKIMVerify.DKIM_AUTH_RESULT, String.class);
        Assertions.assertThat((Optional)attr).hasValueSatisfying(result -> Assertions.assertThat((String)result).startsWith((CharSequence)"pass"));
    }

    @Test
    void testDKIMVerifyFail() throws Exception {
        String message = "DKIM-Signature: v=1; d=example.com; t=1284762805; b=ZFfwSIzTQM7k9syRnl9VfQh0/dr99euvBe1gn/DiTrnEZjxyjzQBD2MMvowVdbHpPMtSjtCtehU9zZ3urXmj5iHKujpEkP92FEKinzElkQ2eT2zoxdg1zByPHsKPX+KjrBespAJcO2k052aOK5kIBFxpQumP4aiW7ZklBKSWMBk=; s=selector; a=rsa-sha256; bh=rHOD7fd9xnNxK7OSl5ellpQVF14NNFbOIizqtUMhnio=; h=from:to:received:received;\r\nReceived: by 10.XX.XX.12 with SMTP id dfgskldjfhgkljsdfhgkljdhfg;\r\n\tTue, 06 Oct 2009 07:37:34 -0700 (PDT)\r\nReturn-Path: <bounce@example.com>\r\nReceived: from example.co.uk (example.co.uk [XX.XXX.125.19])\r\n\tby mx.example.com with ESMTP id dgdfgsdfgsd.97.2009.10.06.07.37.32;\r\n\tTue, 06 Oct 2009 07:37:32 -0700 (PDT)\r\nFrom: apache@bago.org\r\nTo: apache@bago.org\r\n\r\nbody\r\nprova altered\r\n";
        Mail mail = this.process(message);
        Optional attr = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)DKIMVerify.DKIM_AUTH_RESULT, String.class);
        Assertions.assertThat((Optional)attr).hasValueSatisfying(result -> Assertions.assertThat((String)result).startsWith((CharSequence)"fail"));
    }

    @Test
    void testDKIMVerifyFailInvalid() throws Exception {
        String message = "DKIM-Signature: v=2; d=example.com; t=1284762805; b=ZFfwSIzTQM7k9syRnl9VfQh0/dr99euvBe1gn/DiTrnEZjxyjzQBD2MMvowVdbHpPMtSjtCtehU9zZ3urXmj5iHKujpEkP92FEKinzElkQ2eT2zoxdg1zByPHsKPX+KjrBespAJcO2k052aOK5kIBFxpQumP4aiW7ZklBKSWMBk=; s=selector; a=rsa-sha256; bh=rHOD7fd9xnNxK7OSl5ellpQVF14NNFbOIizqtUMhnio=; h=from:to:received:received;\r\nReceived: by 10.XX.XX.12 with SMTP id dfgskldjfhgkljsdfhgkljdhfg;\r\n\tTue, 06 Oct 2009 07:37:34 -0700 (PDT)\r\nReturn-Path: <bounce@example.com>\r\nReceived: from example.co.uk (example.co.uk [XX.XXX.125.19])\r\n\tby mx.example.com with ESMTP id dgdfgsdfgsd.97.2009.10.06.07.37.32;\r\n\tTue, 06 Oct 2009 07:37:32 -0700 (PDT)\r\nFrom: apache@bago.org\r\nTo: apache@bago.org\r\n\r\nbody\r\nprova\r\n";
        Mail mail = this.process(message);
        Optional attr = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)DKIMVerify.DKIM_AUTH_RESULT, String.class);
        Assertions.assertThat((Optional)attr).hasValueSatisfying(result -> Assertions.assertThat((String)result).startsWith((CharSequence)"fail"));
    }

    @Test
    void testDKIMVerifyNeutral() throws Exception {
        String message = "Received: by 10.XX.XX.12 with SMTP id dfgskldjfhgkljsdfhgkljdhfg;\r\n\tTue, 06 Oct 2009 07:37:34 -0700 (PDT)\r\nReturn-Path: <bounce@example.com>\r\nReceived: from example.co.uk (example.co.uk [XX.XXX.125.19])\r\n\tby mx.example.com with ESMTP id dgdfgsdfgsd.97.2009.10.06.07.37.32;\r\n\tTue, 06 Oct 2009 07:37:32 -0700 (PDT)\r\nFrom: apache@bago.org\r\nTo: apache@bago.org\r\n\r\nbody\r\nprova altered\r\n";
        Mail mail = this.process(message);
        Optional attr = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)DKIMVerify.DKIM_AUTH_RESULT, String.class);
        Assertions.assertThat((Optional)attr).hasValueSatisfying(result -> Assertions.assertThat((String)result).startsWith((CharSequence)"neutral"));
    }

    private Mail process(String message) throws Exception {
        DKIMVerify mailet = new DKIMVerify((PublicKeyRecordRetriever)new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", (CharSequence)"selector", (CharSequence)"example.com"));
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)FakeMailContext.defaultContext()).build();
        mailet.init((MailetConfig)mci);
        FakeMail mail = FakeMail.builder().name("test").mimeMessage(new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new ByteArrayInputStream(message.getBytes()))).build();
        mailet.service((Mail)mail);
        return mail;
    }
}

