/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.mailets.ConvertTo7Bit;
import org.apache.james.jdkim.mailets.DKIMSign;
import org.apache.james.jdkim.mailets.DKIMVerifier;
import org.apache.james.jdkim.mailets.MockPublicKeyRecordRetriever;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.util.MimeMessageUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMailContext;
import org.apache.mailet.base.test.FakeMailetConfig;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class DKIMSignTest {
    private static final String PKCS1_PEM_FILE = "classpath://test-dkim-pkcs1.pem";
    private static final String PKCS8_PEM_FILE = "classpath://test-dkim-pkcs8.pem";
    private static final FakeMailContext FAKE_MAIL_CONTEXT = FakeMailContext.defaultContext();
    FileSystem fileSystem;

    DKIMSignTest() {
    }

    @BeforeEach
    void setUp() {
        this.fileSystem = FileSystemImpl.forTesting();
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath://test-dkim-pkcs1.pem", "classpath://test-dkim-pkcs8.pem"})
    void testDKIMSign(String pemFile) throws MessagingException, IOException, FailException {
        String message = "Received: by 10.XX.XX.12 with SMTP id dfgskldjfhgkljsdfhgkljdhfg;\r\n\tTue, 06 Oct 2009 07:37:34 -0700 (PDT)\r\nReturn-Path: <bounce@example.com>\r\nReceived: from example.co.uk (example.co.uk [XX.XXX.125.19])\r\n\tby mx.example.com with ESMTP id dgdfgsdfgsd.97.2009.10.06.07.37.32;\r\n\tTue, 06 Oct 2009 07:37:32 -0700 (PDT)\r\nFrom: apache@bago.org\r\nTo: apache@bago.org\r\n\r\nbody\r\nprova\r\n";
        DKIMSign mailet = new DKIMSign(this.fileSystem);
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)FAKE_MAIL_CONTEXT).setProperty("signatureTemplate", "v=1; s=selector; d=example.com; h=from:to:received:received; a=rsa-sha256; bh=; b=;").setProperty("privateKeyFilepath", pemFile).build();
        mailet.init((MailetConfig)mci);
        FakeMail mail = FakeMail.builder().name("test").mimeMessage(new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new ByteArrayInputStream(message.getBytes()))).build();
        mailet.service((Mail)mail);
        ConvertTo7Bit m7bit = new ConvertTo7Bit();
        m7bit.init((MailetConfig)mci);
        m7bit.service((Mail)mail);
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)rawMessage);
        MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever = new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", (CharSequence)"selector", (CharSequence)"example.com");
        this.verify(rawMessage, mockPublicKeyRecordRetriever);
    }

    private List<SignatureRecord> verify(ByteArrayOutputStream rawMessage, MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever) throws MessagingException, FailException {
        List signs = new DKIMVerifier((PublicKeyRecordRetriever)mockPublicKeyRecordRetriever).verifyUsingCRLF(MimeMessageUtil.mimeMessageFromStream((InputStream)new ByteArrayInputStream(rawMessage.toByteArray())));
        Assertions.assertThat((List)signs).hasSize(1);
        return signs;
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath://test-dkim-pkcs1.pem", "classpath://test-dkim-pkcs8.pem"})
    void testDKIMSignFuture(String pemFile) throws MessagingException, IOException, FailException {
        String message = "Received: by 10.XX.XX.12 with SMTP id dfgskldjfhgkljsdfhgkljdhfg;\r\n\tTue, 06 Oct 2009 07:37:34 -0700 (PDT)\r\nReturn-Path: <bounce@example.com>\r\nReceived: from example.co.uk (example.co.uk [XX.XXX.125.19])\r\n\tby mx.example.com with ESMTP id dgdfgsdfgsd.97.2009.10.06.07.37.32;\r\n\tTue, 06 Oct 2009 07:37:32 -0700 (PDT)\r\nFrom: apache@bago.org\r\nTo: apache@bago.org\r\n\r\nbody\r\nprova\r\n";
        DKIMSign mailet = new DKIMSign(this.fileSystem);
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)FAKE_MAIL_CONTEXT).setProperty("signatureTemplate", "v=1; t=" + (System.currentTimeMillis() / 1000L + 1000L) + "; s=selector; d=example.com; h=from:to:received:received; a=rsa-sha256; bh=; b=;").setProperty("privateKeyFilepath", pemFile).build();
        mailet.init((MailetConfig)mci);
        FakeMail mail = FakeMail.builder().name("test").mimeMessage(new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new ByteArrayInputStream(message.getBytes()))).build();
        mailet.service((Mail)mail);
        ConvertTo7Bit m7bit = new ConvertTo7Bit();
        m7bit.init((MailetConfig)mci);
        m7bit.service((Mail)mail);
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)rawMessage);
        MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever = new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", (CharSequence)"selector", (CharSequence)"example.com");
        try {
            this.verify(rawMessage, mockPublicKeyRecordRetriever);
            Fail.fail((String)"Expecting signature to be ignored");
        }
        catch (PermFailException permFailException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath://test-dkim-pkcs1.pem", "classpath://test-dkim-pkcs8.pem"})
    void testDKIMSignTime(String pemFile) throws MessagingException, IOException, FailException {
        String message = "Received: by 10.XX.XX.12 with SMTP id dfgskldjfhgkljsdfhgkljdhfg;\r\n\tTue, 06 Oct 2009 07:37:34 -0700 (PDT)\r\nReturn-Path: <bounce@example.com>\r\nReceived: from example.co.uk (example.co.uk [XX.XXX.125.19])\r\n\tby mx.example.com with ESMTP id dgdfgsdfgsd.97.2009.10.06.07.37.32;\r\n\tTue, 06 Oct 2009 07:37:32 -0700 (PDT)\r\nFrom: apache@bago.org\r\nTo: apache@bago.org\r\n\r\nbody\r\nprova\r\n";
        DKIMSign mailet = new DKIMSign(this.fileSystem);
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)FAKE_MAIL_CONTEXT).setProperty("signatureTemplate", "v=1; t=; s=selector; d=example.com; h=from:to:received:received; a=rsa-sha256; bh=; b=;").setProperty("privateKeyFilepath", pemFile).build();
        mailet.init((MailetConfig)mci);
        FakeMail mail = FakeMail.builder().name("test").mimeMessage(new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new ByteArrayInputStream(message.getBytes()))).build();
        mailet.service((Mail)mail);
        ConvertTo7Bit m7bit = new ConvertTo7Bit();
        m7bit.init((MailetConfig)mci);
        m7bit.service((Mail)mail);
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)rawMessage);
        MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever = new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", (CharSequence)"selector", (CharSequence)"example.com");
        this.verify(rawMessage, mockPublicKeyRecordRetriever);
        List<SignatureRecord> rs = this.verify(rawMessage, mockPublicKeyRecordRetriever);
        Assertions.assertThat((Long)rs.get(0).getSignatureTimestamp()).isNotNull();
        long ref = System.currentTimeMillis() / 1000L;
        Assertions.assertThat((rs.get(0).getSignatureTimestamp() <= ref ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((rs.get(0).getSignatureTimestamp() >= ref - 60L ? 1 : 0) != 0).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath://test-dkim-pkcs1.pem", "classpath://test-dkim-pkcs8.pem"})
    void testDKIMSignMessageAsText(String pemFile) throws MessagingException, IOException, FailException {
        MimeMessage mm = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        mm.addFrom(new Address[]{new InternetAddress("io@bago.org")});
        mm.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress("io@bago.org"));
        mm.setText("An 8bit encoded body with \u20acuro symbol.", "ISO-8859-15");
        DKIMSign mailet = new DKIMSign(this.fileSystem);
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)FAKE_MAIL_CONTEXT).setProperty("signatureTemplate", "v=1; s=selector; d=example.com; h=from:to:received:received; a=rsa-sha256; bh=; b=;").setProperty("privateKeyFilepath", pemFile).build();
        mailet.init((MailetConfig)mci);
        FakeMail mail = FakeMail.builder().name("test").mimeMessage(mm).build();
        ConvertTo7Bit m7bit = new ConvertTo7Bit();
        m7bit.init((MailetConfig)mci);
        mailet.service((Mail)mail);
        m7bit.service((Mail)mail);
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)rawMessage);
        MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever = new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", (CharSequence)"selector", (CharSequence)"example.com");
        this.verify(rawMessage, mockPublicKeyRecordRetriever);
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath://test-dkim-pkcs1.pem", "classpath://test-dkim-pkcs8.pem"})
    void testDKIMSignMessageAsObjectConvertedTo7Bit(String pemFile) throws MessagingException, IOException, FailException {
        MimeMessage mm = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        mm.addFrom(new Address[]{new InternetAddress("io@bago.org")});
        mm.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress("io@bago.org"));
        mm.setContent((Object)"An 8bit encoded body with \u20acuro symbol.", "text/plain; charset=iso-8859-15");
        mm.setHeader("Content-Transfer-Encoding", "8bit");
        mm.saveChanges();
        FAKE_MAIL_CONTEXT.getServerInfo();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)FAKE_MAIL_CONTEXT).setProperty("signatureTemplate", "v=1; s=selector; d=example.com; h=from:to:received:received; a=rsa-sha256; bh=; b=;").setProperty("privateKeyFilepath", pemFile).build();
        FakeMail mail = FakeMail.builder().name("test").mimeMessage(mm).build();
        DKIMSign mailet = new DKIMSign(this.fileSystem);
        mailet.init((MailetConfig)mci);
        ConvertTo7Bit m7bit = new ConvertTo7Bit();
        m7bit.init((MailetConfig)mci);
        m7bit.service((Mail)mail);
        mailet.service((Mail)mail);
        m7bit.service((Mail)mail);
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)rawMessage);
        MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever = new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", (CharSequence)"selector", (CharSequence)"example.com");
        this.verify(rawMessage, mockPublicKeyRecordRetriever);
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath://test-dkim-pkcs1.pem", "classpath://test-dkim-pkcs8.pem"})
    void testDKIMSignMessageAsObjectNotConverted(String pemFile) throws MessagingException, IOException, FailException {
        MimeMessage mm = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        mm.addFrom(new Address[]{new InternetAddress("io@bago.org")});
        mm.addRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress("io@bago.org"));
        mm.setContent((Object)"An 8bit encoded body with \u20acuro symbol.", "text/plain; charset=iso-8859-15");
        mm.setHeader("Content-Transfer-Encoding", "8bit");
        mm.saveChanges();
        FAKE_MAIL_CONTEXT.getServerInfo();
        FakeMailetConfig mci = FakeMailetConfig.builder().mailetName("Test").mailetContext((MailetContext)FAKE_MAIL_CONTEXT).setProperty("signatureTemplate", "v=1; s=selector; d=example.com; h=from:to:received:received; a=rsa-sha256; bh=; b=;").setProperty("privateKeyFilepath", pemFile).build();
        FakeMail mail = FakeMail.builder().name("test").mimeMessage(mm).build();
        DKIMSign mailet = new DKIMSign(this.fileSystem);
        mailet.init((MailetConfig)mci);
        ConvertTo7Bit m7bit = new ConvertTo7Bit();
        m7bit.init((MailetConfig)mci);
        mailet.service((Mail)mail);
        m7bit.service((Mail)mail);
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)rawMessage);
        MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever = new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", (CharSequence)"selector", (CharSequence)"example.com");
        try {
            this.verify(rawMessage, mockPublicKeyRecordRetriever);
            Fail.fail((String)"Expected PermFail");
        }
        catch (PermFailException permFailException) {
            // empty catch block
        }
    }
}

