/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import java.util.List;
import org.apache.james.adapter.mailbox.ReIndexerManagement;
import org.apache.james.core.Username;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ReIndexerManagementTest {
    private ReIndexerManagement testee;
    private TaskManager taskManager;
    private ReIndexer reIndexer;

    @BeforeEach
    void setUp() {
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        this.reIndexer = (ReIndexer)Mockito.mock(ReIndexer.class);
        this.testee = new ReIndexerManagement(this.taskManager, this.reIndexer);
    }

    @Test
    void reIndexMailboxShouldWaitsForExecution() throws Exception {
        Task task = new Task(this){

            public Task.Result run() {
                return Task.Result.COMPLETED;
            }

            public TaskType type() {
                return TaskType.of((String)"FakeReindexing");
            }
        };
        String namespace = "namespace";
        String user = "user";
        String name = "name";
        Mockito.when((Object)this.reIndexer.reIndex((MailboxPath)ArgumentMatchers.any(MailboxPath.class), (ReIndexer.RunningOptions)ArgumentMatchers.any(ReIndexer.RunningOptions.class))).thenReturn((Object)task);
        Assertions.assertThat((List)this.taskManager.list()).isEmpty();
        this.testee.reIndex(namespace, user, name);
        ((ReIndexer)Mockito.verify((Object)this.reIndexer)).reIndex(new MailboxPath(namespace, Username.of((String)user), name), ReIndexer.RunningOptions.DEFAULT);
        Assertions.assertThat((List)this.taskManager.list()).hasSize(1);
    }

    @Test
    void reIndexShouldWaitsForExecution() throws Exception {
        Task task = new Task(this){

            public Task.Result run() {
                return Task.Result.COMPLETED;
            }

            public TaskType type() {
                return TaskType.of((String)"FakeReindexing");
            }
        };
        Mockito.when((Object)this.reIndexer.reIndex((ReIndexer.RunningOptions)ArgumentMatchers.any(ReIndexer.RunningOptions.class))).thenReturn((Object)task);
        Assertions.assertThat((List)this.taskManager.list()).isEmpty();
        this.testee.reIndex();
        ((ReIndexer)Mockito.verify((Object)this.reIndexer)).reIndex(ReIndexer.RunningOptions.DEFAULT);
        Assertions.assertThat((List)this.taskManager.list()).hasSize(1);
    }
}

