/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.adapter.mailbox.MailboxManagerManagement;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MailboxManagementTest {
    public static final Username USER = Username.of((String)"user");
    public static final UidValidity UID_VALIDITY = UidValidity.of((long)10L);
    public static final int LIMIT = 1;
    private MailboxManagerManagement mailboxManagerManagement;
    private MailboxSessionMapperFactory mapperFactory;
    private MailboxSession session;

    @BeforeEach
    void setUp() throws Exception {
        InMemoryMailboxManager mailboxManager = InMemoryIntegrationResources.defaultResources().getMailboxManager();
        this.mapperFactory = mailboxManager.getMapperFactory();
        this.mailboxManagerManagement = new MailboxManagerManagement();
        this.mailboxManagerManagement.setMailboxManager((MailboxManager)mailboxManager);
        this.session = mailboxManager.createSystemSession(Username.of((String)"TEST"));
    }

    @Test
    void deleteMailboxesShouldDeleteMailboxes() throws Exception {
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailboxes(USER.asString());
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).isEmpty();
    }

    @Test
    void deleteMailboxesShouldDeleteInbox() throws Exception {
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.inbox((Username)USER), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailboxes(USER.asString());
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).isEmpty();
    }

    @Test
    void deleteMailboxesShouldDeleteMailboxesChildren() throws Exception {
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"INBOX.test"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailboxes(USER.asString());
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).isEmpty();
    }

    @Test
    void deleteMailboxesShouldNotDeleteMailboxesBelongingToNotPrivateNamespace() throws Exception {
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(new MailboxPath("#top", USER, "name"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailboxes(USER.asString());
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).containsExactly((Object[])new Mailbox[]{mailbox});
    }

    @Test
    void deleteMailboxesShouldNotDeleteMailboxesBelongingToOtherUsers() throws Exception {
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)Username.of((String)"userbis"), (String)"name"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailboxes(USER.asString());
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).containsExactly((Object[])new Mailbox[]{mailbox});
    }

    @Test
    void deleteMailboxesShouldDeleteMailboxesWithEmptyNames() throws Exception {
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)""), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailboxes(USER.asString());
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).isEmpty();
    }

    @Test
    void deleteMailboxesShouldThrowOnNullUserName() throws Exception {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailboxes(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void deleteMailboxesShouldThrowOnEmptyUserName() throws Exception {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailboxes("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void deleteMailboxesShouldDeleteMultipleMailboxes() throws Exception {
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY).block();
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"INBOX"), UID_VALIDITY).block();
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"INBOX.test"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailboxes(USER.asString());
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).isEmpty();
    }

    @Test
    void createMailboxShouldCreateAMailbox() throws Exception {
        this.mailboxManagerManagement.createMailbox("#private", USER.asString(), "name");
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).hasSize(1);
        Assertions.assertThat((Optional)this.mapperFactory.createMailboxMapper(this.session).findMailboxByPath(MailboxPath.forUser((Username)USER, (String)"name")).blockOptional()).isPresent();
    }

    @Test
    void createMailboxShouldThrowIfMailboxAlreadyExists() throws Exception {
        MailboxPath path = MailboxPath.forUser((Username)USER, (String)"name");
        this.mapperFactory.createMailboxMapper(this.session).create(path, UID_VALIDITY).block();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.createMailbox("#private", USER.asString(), "name")).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(MailboxExistsException.class);
    }

    @Test
    void createMailboxShouldNotCreateAdditionalMailboxesIfMailboxAlreadyExists() throws Exception {
        MailboxPath path = MailboxPath.forUser((Username)USER, (String)"name");
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(path, UID_VALIDITY).block();
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).containsExactly((Object[])new Mailbox[]{mailbox});
    }

    @Test
    void createMailboxShouldThrowOnNullNamespace() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.createMailbox(null, "a", "a")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void createMailboxShouldThrowOnNullUser() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.createMailbox("a", null, "a")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void createMailboxShouldThrowOnNullName() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.createMailbox("a", "a", null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void createMailboxShouldThrowOnEmptyNamespace() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.createMailbox("", "a", "a")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void createMailboxShouldThrowOnEmptyUser() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.createMailbox("a", "", "a")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void createMailboxShouldThrowOnEmptyName() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.createMailbox("a", "a", "")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void listMailboxesShouldReturnUserMailboxes() throws Exception {
        MailboxMapper mapper = this.mapperFactory.createMailboxMapper(this.session);
        mapper.create(new MailboxPath("#top", USER, "name1"), UID_VALIDITY).block();
        mapper.create(MailboxPath.forUser((Username)USER, (String)"name2"), UID_VALIDITY).block();
        mapper.create(MailboxPath.forUser((Username)Username.of((String)"other_user"), (String)"name3"), UID_VALIDITY).block();
        mapper.create(MailboxPath.forUser((Username)USER, (String)"name4"), UID_VALIDITY).block();
        mapper.create(MailboxPath.forUser((Username)USER, (String)"INBOX"), UID_VALIDITY).block();
        mapper.create(MailboxPath.forUser((Username)USER, (String)"INBOX.toto"), UID_VALIDITY).block();
        Assertions.assertThat((List)this.mailboxManagerManagement.listMailboxes(USER.asString())).containsOnly((Object[])new String[]{"name2", "name4", "INBOX", "INBOX.toto"});
    }

    @Test
    void listMailboxesShouldThrowOnNullUserName() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.listMailboxes(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void listMailboxesShouldThrowOnEmptyUserName() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.listMailboxes("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void deleteMailboxShouldDeleteGivenMailbox() throws Exception {
        this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailbox("#private", USER.asString(), "name");
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).isEmpty();
    }

    @Test
    void deleteMailboxShouldNotDeleteGivenMailboxIfWrongNamespace() throws Exception {
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(new MailboxPath("#top", USER, "name"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailbox("#private", USER.asString(), "name");
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).containsOnly((Object[])new Mailbox[]{mailbox});
    }

    @Test
    void deleteMailboxShouldNotDeleteGivenMailboxIfWrongUser() throws Exception {
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)Username.of((String)"userbis"), (String)"name"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailbox("#private", USER.asString(), "name");
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).containsOnly((Object[])new Mailbox[]{mailbox});
    }

    @Test
    void deleteMailboxShouldNotDeleteGivenMailboxIfWrongName() throws Exception {
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"wrong_name"), UID_VALIDITY).block();
        this.mailboxManagerManagement.deleteMailbox("#private", USER.asString(), "name");
        Assertions.assertThat((List)((List)this.mapperFactory.createMailboxMapper(this.session).list().collectList().block())).containsOnly((Object[])new Mailbox[]{mailbox});
    }

    @Test
    void importEmlFileToMailboxShouldImportEmlFileToGivenMailbox() throws Exception {
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY).block();
        String emlpath = ClassLoader.getSystemResource("eml/frnog.eml").getFile();
        this.mailboxManagerManagement.importEmlFileToMailbox("#private", USER.asString(), "name", emlpath);
        Assertions.assertThat((long)this.mapperFactory.getMessageMapper(this.session).countMessagesInMailbox(mailbox)).isEqualTo(1L);
        Iterator iterator = this.mapperFactory.getMessageMapper(this.session).findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.FULL, 1);
        MailboxMessage mailboxMessage = (MailboxMessage)iterator.next();
        Assertions.assertThat((String)IOUtils.toString((InputStream)new FileInputStream(new File(emlpath)), (Charset)StandardCharsets.UTF_8)).isEqualTo(IOUtils.toString((InputStream)mailboxMessage.getFullContent(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    void importEmlFileToMailboxShouldNotImportEmlFileWithWrongPathToGivenMailbox() throws Exception {
        Mailbox mailbox = (Mailbox)this.mapperFactory.createMailboxMapper(this.session).create(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY).block();
        String emlpath = ClassLoader.getSystemResource("eml/frnog.eml").getFile();
        this.mailboxManagerManagement.importEmlFileToMailbox("#private", USER.asString(), "name", "wrong_path" + emlpath);
        Assertions.assertThat((long)this.mapperFactory.getMessageMapper(this.session).countMessagesInMailbox(mailbox)).isEqualTo(0L);
        Iterator iterator = this.mapperFactory.getMessageMapper(this.session).findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.FULL, 1);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    void deleteMailboxShouldThrowOnNullNamespace() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailbox(null, "a", "a")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void deleteMailboxShouldThrowOnNullUser() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailbox("a", null, "a")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void deleteMailboxShouldThrowOnNullName() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailbox("a", "a", null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void deleteMailboxShouldThrowOnEmptyNamespace() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailbox("", "a", "a")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void deleteMailboxShouldThrowOnEmptyUser() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailbox("a", "", "a")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void deleteMailboxShouldThrowOnEmptyName() {
        Assertions.assertThatThrownBy(() -> this.mailboxManagerManagement.deleteMailbox("a", "a", "")).isInstanceOf(IllegalArgumentException.class);
    }
}

