/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import org.apache.james.ExtraProperties;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JPAJamesConfiguration;
import org.apache.james.JamesServerMain;
import org.apache.james.NaiveDelegationStoreModule;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.modules.MailetProcessingModule;
import org.apache.james.modules.RunArgumentsModule;
import org.apache.james.modules.data.JPAAuthorizatorModule;
import org.apache.james.modules.data.JPADataModule;
import org.apache.james.modules.data.JPAEntityManagerModule;
import org.apache.james.modules.data.JPAUsersRepositoryModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.queue.activemq.ActiveMQQueueModule;
import org.apache.james.modules.server.DKIMMailetModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.DefaultProcessorsConfigurationProviderModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.NoJwtModule;
import org.apache.james.modules.server.RawPostDequeueDecoratorModule;
import org.apache.james.modules.server.TaskManagerModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.server.core.configuration.Configuration;

public class JPAJamesServerMain
implements JamesServerMain {
    private static final Module PROTOCOLS = Modules.combine((Module[])new Module[]{new ProtocolHandlerModule(), new SMTPServerModule(), new WebAdminServerModule(), new DataRoutesModules(), new MailRepositoriesRoutesModule(), new MailQueueRoutesModule(), new NoJwtModule(), new DefaultProcessorsConfigurationProviderModule(), new TaskManagerModule()});
    private static final Module JPA_SERVER_MODULE = Modules.combine((Module[])new Module[]{new NaiveDelegationStoreModule(), new MailetProcessingModule(), new JPAEntityManagerModule(), new JPADataModule(), new ActiveMQQueueModule(), new RawPostDequeueDecoratorModule(), new JPAAuthorizatorModule()});

    public static void main(String[] args) throws Exception {
        ExtraProperties.initialize();
        JPAJamesConfiguration configuration = JPAJamesConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = JPAJamesServerMain.createServer(configuration).overrideWith(new Module[]{new RunArgumentsModule(args)});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    public static GuiceJamesServer createServer(JPAJamesConfiguration configuration) {
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{JPA_SERVER_MODULE, PROTOCOLS, new DKIMMailetModule()}).combineWith((Collection)new UsersRepositoryModuleChooser((Module)new JPAUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation()));
    }
}

