/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.utils.PropertiesProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WebAdminServerModuleTest {
    WebAdminServerModuleTest() {
    }

    @Test
    void shouldReturnEmptyWhenNoField() throws Exception {
        Configuration configuration = this.getConfiguration("webadmin-none");
        Assertions.assertThat((List)new WebAdminServerModule().additionalRoutes(configuration)).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenEmptyField() throws Exception {
        Configuration configuration = this.getConfiguration("webadmin-empty");
        Assertions.assertThat((List)new WebAdminServerModule().additionalRoutes(configuration)).isEmpty();
    }

    @Test
    void shouldReturnOneRoutes() throws Exception {
        Configuration configuration = this.getConfiguration("webadmin-one");
        Assertions.assertThat((List)new WebAdminServerModule().additionalRoutes(configuration)).containsOnly((Object[])new String[]{"org.apache.custom.webadmin.CustomRoute"});
    }

    @Test
    void shouldReturnSeveralRoutes() throws Exception {
        Configuration configuration = this.getConfiguration("webadmin-two");
        Assertions.assertThat((List)new WebAdminServerModule().additionalRoutes(configuration)).containsOnly((Object[])new String[]{"org.apache.custom.webadmin.CustomRoute", "org.apache.custom.webadmin.AnotherCustomRoute"});
    }

    private Configuration getConfiguration(String name) throws Exception {
        return PropertiesProvider.forTesting().getConfiguration(name);
    }
}

