/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.modules.mailbox.PreDeletionHookConfiguration;
import org.apache.james.modules.mailbox.PreDeletionHooksConfiguration;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PreDeletionHooksConfigurationTest {
    PreDeletionHooksConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(PreDeletionHooksConfiguration.class).verify();
    }

    @Test
    void fromShouldReturnNoneWhenEmpty() throws Exception {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        Assertions.assertThat((Object)PreDeletionHooksConfiguration.from((HierarchicalConfiguration)configuration)).isEqualTo((Object)PreDeletionHooksConfiguration.none());
    }

    @Test
    void fromShouldThrowWhenInvalidHookConfiguration() throws Exception {
        XMLConfiguration configuration = FileConfigurationProvider.getConfig((InputStream)new ByteArrayInputStream("<preDeletionHooks>  <preDeletionHook>    <class></class>  </preDeletionHook></preDeletionHooks>".getBytes(StandardCharsets.UTF_8)));
        BaseHierarchicalConfiguration invalidConfigurationEntry = new BaseHierarchicalConfiguration();
        configuration.addProperty("preDeletionHook", (Object)ImmutableList.of((Object)invalidConfigurationEntry));
        Assertions.assertThatThrownBy(() -> PreDeletionHooksConfiguration.from((HierarchicalConfiguration)configuration)).isInstanceOf(ConfigurationException.class);
    }

    @Test
    void fromShouldReturnConfiguredEntry() throws Exception {
        XMLConfiguration configuration = FileConfigurationProvider.getConfig((InputStream)new ByteArrayInputStream("<preDeletionHooks>  <preDeletionHook>    <class>a.class</class>  </preDeletionHook></preDeletionHooks>".getBytes(StandardCharsets.UTF_8)));
        String className = "a.class";
        Assertions.assertThat((Object)PreDeletionHooksConfiguration.from((HierarchicalConfiguration)configuration)).isEqualTo((Object)new PreDeletionHooksConfiguration((List)ImmutableList.of((Object)PreDeletionHookConfiguration.forClass((String)className))));
    }

    @Test
    void fromShouldReturnAllConfiguredEntries() throws Exception {
        XMLConfiguration configuration = FileConfigurationProvider.getConfig((InputStream)new ByteArrayInputStream("<preDeletionHooks>  <preDeletionHook>    <class>a.class</class>  </preDeletionHook>  <preDeletionHook>    <class>b.class</class>  </preDeletionHook></preDeletionHooks>".getBytes(StandardCharsets.UTF_8)));
        String className1 = "a.class";
        String className2 = "b.class";
        Assertions.assertThat((Object)PreDeletionHooksConfiguration.from((HierarchicalConfiguration)configuration)).isEqualTo((Object)new PreDeletionHooksConfiguration((List)ImmutableList.of((Object)PreDeletionHookConfiguration.forClass((String)className1), (Object)PreDeletionHookConfiguration.forClass((String)className2))));
    }
}

