/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import java.io.FileNotFoundException;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.modules.mailbox.NoopPreDeletionHook;
import org.apache.james.modules.mailbox.PreDeletionHookConfiguration;
import org.apache.james.modules.mailbox.PreDeletionHookLoaderImpl;
import org.apache.james.utils.ExtendedClassLoader;
import org.apache.james.utils.GuiceGenericLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class PreDeletionHookLoaderImplTest {
    private PreDeletionHookLoaderImpl testee;

    PreDeletionHookLoaderImplTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fileSystem.getFile(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new FileNotFoundException()});
        this.testee = new PreDeletionHookLoaderImpl(GuiceGenericLoader.forTesting((ExtendedClassLoader)new ExtendedClassLoader(fileSystem)));
    }

    @Test
    void createHookShouldThrowWhenClassNotFound() {
        Assertions.assertThatThrownBy(() -> this.testee.createHook(PreDeletionHookConfiguration.forClass((String)"invalid"))).isInstanceOf(ClassNotFoundException.class);
    }

    @Test
    void createHookShouldReturnAHookOfCreatedClass() throws Exception {
        Assertions.assertThat((Object)this.testee.createHook(PreDeletionHookConfiguration.forClass((String)NoopPreDeletionHook.class.getName()))).isInstanceOf(NoopPreDeletionHook.class);
    }
}

