/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.filesystem.api.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.james.filesystem.api.FileSystem;
import org.junit.rules.TemporaryFolder;

public class MockFileSystem
implements FileSystem {
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();

    public MockFileSystem() throws IOException {
        this.temporaryFolder.create();
    }

    public File getBasedir() throws FileNotFoundException {
        return this.temporaryFolder.getRoot();
    }

    public InputStream getResource(String url) throws IOException {
        return new FileInputStream(this.getFile(url));
    }

    public File getFile(String fileURL) throws FileNotFoundException {
        try {
            if (fileURL.startsWith("file://")) {
                if (fileURL.startsWith("file://conf/")) {
                    URL url = MockFileSystem.class.getClassLoader().getResource("./" + fileURL.substring(12));
                    try {
                        return new File(new URI(url.toString()));
                    }
                    catch (URISyntaxException e) {
                        throw new FileNotFoundException("Unable to load file");
                    }
                }
                return new File(String.valueOf(this.temporaryFolder.getRoot()) + File.separator + fileURL.substring("file://".length()));
            }
            throw new UnsupportedOperationException("getFile: " + fileURL);
        }
        catch (NullPointerException npe) {
            throw new FileNotFoundException("NPE on: " + fileURL);
        }
    }

    public void clear() {
        this.temporaryFolder.delete();
    }
}

