/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.memory;

import java.util.Optional;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.InMemoryDNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.lib.UsersRepositoryContract;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class MemoryUsersRepositoryTest {
    private static final String LOCALHOST = "localhost";
    private static final String LOCALHOST_ADDRESS = "127.0.0.1";

    MemoryUsersRepositoryTest() {
    }

    private HierarchicalConfiguration<ImmutableNode> configuration(Optional<Username> administrator, boolean enableVirtualHosting) {
        BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
        administrator.ifPresent(username -> configuration.addProperty("administratorId", (Object)username.asString()));
        configuration.addProperty("enableVirtualHosting", (Object)enableVirtualHosting);
        configuration.addProperty("algorithm", (Object)"none");
        return configuration;
    }

    @Nested
    class WhenDisableVirtualHosting
    implements UsersRepositoryContract.WithOutVirtualHostingContract {
        @RegisterExtension
        UsersRepositoryContract.UserRepositoryExtension extension = UsersRepositoryContract.UserRepositoryExtension.withoutVirtualHosting();
        private MemoryUsersRepository memoryUsersRepository;
        private UsersRepositoryContract.TestSystem testSystem;

        WhenDisableVirtualHosting() {
        }

        @BeforeEach
        void setUp(UsersRepositoryContract.TestSystem testSystem) {
            this.memoryUsersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)testSystem.getDomainList());
            this.testSystem = testSystem;
        }

        public UsersRepository testee() {
            return this.memoryUsersRepository;
        }

        public UsersRepository testee(Optional<Username> administrator) throws Exception {
            MemoryUsersRepository memoryUsersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)this.testSystem.getDomainList());
            memoryUsersRepository.configure(MemoryUsersRepositoryTest.this.configuration(administrator, false));
            return memoryUsersRepository;
        }

        @Test
        void assertValidShouldThrowWhenDomainPartAndNoVirtualHosting(UsersRepositoryContract.TestSystem testSystem) {
            MemoryUsersRepository memoryUsersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)testSystem.getDomainList());
            Assertions.assertThatThrownBy(() -> memoryUsersRepository.assertValid(Username.of((String)"user@domain.tld"))).isInstanceOf(UsersRepositoryException.class);
        }

        @Test
        void assertValidShouldNotThrowWhenNoDomainPartAndNoVirtualHosting(UsersRepositoryContract.TestSystem testSystem) {
            MemoryUsersRepository memoryUsersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)testSystem.getDomainList());
            Assertions.assertThatCode(() -> memoryUsersRepository.assertValid(Username.of((String)"user"))).doesNotThrowAnyException();
        }
    }

    @Nested
    class WhenEnableVirtualHosting
    implements UsersRepositoryContract.WithVirtualHostingContract {
        @RegisterExtension
        UsersRepositoryContract.UserRepositoryExtension extension = UsersRepositoryContract.UserRepositoryExtension.withVirtualHost();
        private MemoryUsersRepository memoryUsersRepository;
        private UsersRepositoryContract.TestSystem testSystem;

        WhenEnableVirtualHosting() {
        }

        @BeforeEach
        void setUp(UsersRepositoryContract.TestSystem testSystem) {
            this.memoryUsersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)testSystem.getDomainList());
            this.testSystem = testSystem;
        }

        public UsersRepository testee() {
            return this.memoryUsersRepository;
        }

        public UsersRepository testee(Optional<Username> administrator) throws Exception {
            MemoryUsersRepository memoryUsersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)this.testSystem.getDomainList());
            memoryUsersRepository.configure(MemoryUsersRepositoryTest.this.configuration(administrator, true));
            return memoryUsersRepository;
        }

        @Test
        void assertValidShouldThrowWhenNoDomainPartAndVirtualHosting() {
            Assertions.assertThatThrownBy(() -> this.memoryUsersRepository.assertValid(Username.of((String)"user"))).isInstanceOf(UsersRepositoryException.class);
        }

        @Test
        void assertValidShouldNotThrowWhenDomainPartAndVirtualHosting() throws Exception {
            MemoryDomainList domainList = new MemoryDomainList((DNSService)new InMemoryDNSService().registerMxRecord(MemoryUsersRepositoryTest.LOCALHOST, MemoryUsersRepositoryTest.LOCALHOST_ADDRESS).registerMxRecord(MemoryUsersRepositoryTest.LOCALHOST_ADDRESS, MemoryUsersRepositoryTest.LOCALHOST_ADDRESS));
            domainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
            domainList.addDomain(Domain.of((String)"domain.tld"));
            MemoryUsersRepository memoryUsersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
            Assertions.assertThatCode(() -> memoryUsersRepository.assertValid(Username.of((String)"user@domain.tld"))).doesNotThrowAnyException();
        }

        @Test
        void assertValidShouldNotThrowWhenDomainPartAndDomainNotFound() throws Exception {
            MemoryDomainList domainList = new MemoryDomainList((DNSService)new InMemoryDNSService().registerMxRecord(MemoryUsersRepositoryTest.LOCALHOST, MemoryUsersRepositoryTest.LOCALHOST_ADDRESS).registerMxRecord(MemoryUsersRepositoryTest.LOCALHOST_ADDRESS, MemoryUsersRepositoryTest.LOCALHOST_ADDRESS));
            domainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
            MemoryUsersRepository memoryUsersRepository = MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
            Assertions.assertThatThrownBy(() -> memoryUsersRepository.assertValid(Username.of((String)"user@domain.tld"))).isInstanceOf(UsersRepositoryException.class);
        }
    }
}

