/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.memory;

import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.DelegationUsernameChangeTaskStep;
import org.apache.james.user.memory.MemoryDelegationStore;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DelegationUsernameChangeTaskStepTest {
    private static final Username ALICE_OLD = Username.of((String)"alice-old@domain.tld");
    private static final Username ALICE_NEW = Username.of((String)"alice-new@domain.tld");
    private static final Username ANDRE = Username.of((String)"andre@domain.tld");
    private static final Username BOB = Username.of((String)"bob@domain.tld");
    private MemoryDelegationStore delegationStore;
    private DelegationUsernameChangeTaskStep testee;

    DelegationUsernameChangeTaskStepTest() {
    }

    @BeforeEach
    void setUp() {
        this.delegationStore = new MemoryDelegationStore();
        this.testee = new DelegationUsernameChangeTaskStep((DelegationStore)this.delegationStore);
    }

    @Test
    void shouldMigrateDelegationToNewUser() {
        Mono.from((Publisher)this.delegationStore.addAuthorizedUser(BOB).forUser(ALICE_OLD)).block();
        Mono.from((Publisher)this.testee.changeUsername(ALICE_OLD, ALICE_NEW)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.delegationStore.authorizedUsers(ALICE_NEW)).collectList().block())).containsOnly((Object[])new Username[]{BOB});
    }

    @Test
    void shouldRemoveDelegationForOldUser() {
        Mono.from((Publisher)this.delegationStore.addAuthorizedUser(BOB).forUser(ALICE_OLD)).block();
        Mono.from((Publisher)this.delegationStore.addAuthorizedUser(ALICE_OLD).forUser(ANDRE)).block();
        Mono.from((Publisher)this.testee.changeUsername(ALICE_OLD, ALICE_NEW)).block();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((List)Flux.from((Publisher)this.delegationStore.authorizedUsers(ALICE_OLD)).collectList().block()).isEmpty();
            softly.assertThat((List)Flux.from((Publisher)this.delegationStore.delegatedUsers(ALICE_OLD)).collectList().block()).isEmpty();
            softly.assertThat((List)Flux.from((Publisher)this.delegationStore.authorizedUsers(ANDRE)).collectList().block()).doesNotContain((Object[])new Username[]{ALICE_OLD});
            softly.assertThat((List)Flux.from((Publisher)this.delegationStore.delegatedUsers(BOB)).collectList().block()).doesNotContain((Object[])new Username[]{ALICE_OLD});
        });
    }

    @Test
    void shouldMigrateChangesForDelegators() {
        Mono.from((Publisher)this.delegationStore.addAuthorizedUser(ALICE_OLD).forUser(BOB)).block();
        Mono.from((Publisher)this.testee.changeUsername(ALICE_OLD, ALICE_NEW)).block();
        Assertions.assertThat((List)((List)Flux.from((Publisher)this.delegationStore.authorizedUsers(BOB)).collectList().block())).containsOnly((Object[])new Username[]{ALICE_NEW});
    }
}

