/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.memory;

import com.github.fge.lambdas.Throwing;
import cucumber.api.java.Before;
import org.apache.james.UserEntityValidator;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.mock.SimpleDomainList;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.RecipientRewriteTableFixture;
import org.apache.james.rrt.lib.RewriteTablesStepdefs;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;

public class InMemoryStepdefs {
    private final RewriteTablesStepdefs mainStepdefs;

    public InMemoryStepdefs(RewriteTablesStepdefs mainStepdefs) {
        this.mainStepdefs = mainStepdefs;
    }

    @Before
    public void setup() throws Throwable {
        this.mainStepdefs.setUp(Throwing.supplier(this::getRecipientRewriteTable).sneakyThrow());
    }

    private AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception {
        MemoryRecipientRewriteTable rrt = new MemoryRecipientRewriteTable();
        SimpleDomainList domainList = RecipientRewriteTableFixture.domainListForCucumberTests();
        rrt.setDomainList((DomainList)domainList);
        rrt.setUsersRepository((UsersRepository)MemoryUsersRepository.withVirtualHosting((DomainList)domainList));
        rrt.setUserEntityValidator(UserEntityValidator.NOOP);
        return rrt;
    }
}

