/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.memory;

import java.util.Map;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.ForwardUsernameChangeTaskStep;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class ForwardUsernameChangeTaskStepTest {
    private static final Username BOB_OLD = Username.of((String)"bob-old@domain.tld");
    private static final Username BOB_NEW = Username.of((String)"bob-new@domain.tld");
    private MemoryRecipientRewriteTable rrt;
    private ForwardUsernameChangeTaskStep testee;

    ForwardUsernameChangeTaskStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        domainList.addDomain(Domain.of((String)"domain.tld"));
        this.rrt = new MemoryRecipientRewriteTable();
        this.rrt.setUsersRepository((UsersRepository)MemoryUsersRepository.withVirtualHosting((DomainList)domainList));
        this.rrt.setUserEntityValidator(UserEntityValidator.NOOP);
        this.rrt.setDomainList((DomainList)domainList);
        this.rrt.configure((HierarchicalConfiguration)new BaseHierarchicalConfiguration());
        this.testee = new ForwardUsernameChangeTaskStep((RecipientRewriteTable)this.rrt);
    }

    @Test
    void shouldCreateForwardFromOldToNewUser() {
        Mono.from((Publisher)this.testee.changeUsername(BOB_OLD, BOB_NEW)).block();
        ((MapAssert)Assertions.assertThat((Map)this.rrt.getAllMappings()).hasSize(1)).containsEntry((Object)MappingSource.fromUser((Username)BOB_OLD), (Object)MappingsImpl.builder().add(Mapping.forward((String)BOB_NEW.asString())).build());
    }

    @Test
    void shouldMigratePreviousForwards() throws Exception {
        this.rrt.addForwardMapping(MappingSource.fromUser((Username)BOB_OLD), "alice@domain.tld");
        Mono.from((Publisher)this.testee.changeUsername(BOB_OLD, BOB_NEW)).block();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)this.rrt.getAllMappings()).hasSize(2)).containsEntry((Object)MappingSource.fromUser((Username)BOB_OLD), (Object)MappingsImpl.builder().add(Mapping.forward((String)BOB_NEW.asString())).build())).containsEntry((Object)MappingSource.fromUser((Username)BOB_NEW), (Object)MappingsImpl.builder().add(Mapping.forward((String)"alice@domain.tld")).build());
    }

    @Test
    void shouldNotAlterDestinationForwards() throws Exception {
        this.rrt.addForwardMapping(MappingSource.fromUser((Username)BOB_NEW), "alice@domain.tld");
        Mono.from((Publisher)this.testee.changeUsername(BOB_OLD, BOB_NEW)).block();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)this.rrt.getAllMappings()).hasSize(2)).containsEntry((Object)MappingSource.fromUser((Username)BOB_OLD), (Object)MappingsImpl.builder().add(Mapping.forward((String)BOB_NEW.asString())).build())).containsEntry((Object)MappingSource.fromUser((Username)BOB_NEW), (Object)MappingsImpl.builder().add(Mapping.forward((String)"alice@domain.tld")).build());
    }

    @Test
    void shouldPreserveKeepACopy() throws Exception {
        this.rrt.addForwardMapping(MappingSource.fromUser((Username)BOB_OLD), "alice@domain.tld");
        this.rrt.addForwardMapping(MappingSource.fromUser((Username)BOB_OLD), BOB_OLD.asString());
        Mono.from((Publisher)this.testee.changeUsername(BOB_OLD, BOB_NEW)).block();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)this.rrt.getAllMappings()).hasSize(2)).containsEntry((Object)MappingSource.fromUser((Username)BOB_OLD), (Object)MappingsImpl.builder().add(Mapping.forward((String)BOB_NEW.asString())).build())).containsEntry((Object)MappingSource.fromUser((Username)BOB_NEW), (Object)MappingsImpl.builder().add(Mapping.forward((String)BOB_NEW.asString())).add(Mapping.forward((String)"alice@domain.tld")).build());
    }
}

