/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.pushsubscription;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.DeviceClientIdInvalidException;
import org.apache.james.jmap.api.model.ExpireTimeInvalidException;
import org.apache.james.jmap.api.model.InvalidPushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionCreationRequest;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscriptionNotFoundException;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionHelpers;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class MemoryPushSubscriptionRepository
implements PushSubscriptionRepository {
    private final Table<Username, PushSubscriptionId, PushSubscription> table;
    private final Clock clock;

    @Inject
    public MemoryPushSubscriptionRepository(Clock clock) {
        this.clock = clock;
        this.table = HashBasedTable.create();
    }

    @Override
    public Publisher<PushSubscription> save(Username username, PushSubscriptionCreationRequest request) {
        return Mono.just((Object)request).handle((req, sink) -> {
            if (PushSubscriptionHelpers.isInThePast(req.expires(), this.clock)) {
                sink.error((Throwable)new ExpireTimeInvalidException(((PushSubscriptionExpiredTime)req.expires().get()).value(), "expires must be greater than now"));
            }
            if (!this.isUniqueDeviceClientId(username, req.deviceClientId())) {
                sink.error((Throwable)new DeviceClientIdInvalidException(req.deviceClientId(), "deviceClientId must be unique"));
            }
            if (PushSubscriptionHelpers.isInvalidPushSubscriptionKey(req.keys())) {
                sink.error((Throwable)new InvalidPushSubscriptionKeys((PushSubscriptionKeys)req.keys().get()));
            }
        }).thenReturn((Object)PushSubscription.from(request, PushSubscriptionHelpers.evaluateExpiresTime(OptionConverters.toJava((Option)request.expires().map(PushSubscriptionExpiredTime::value)), this.clock))).doOnNext(pushSubscription -> this.table.put((Object)username, (Object)pushSubscription.id(), pushSubscription));
    }

    @Override
    public Publisher<PushSubscriptionExpiredTime> updateExpireTime(Username username, PushSubscriptionId id, ZonedDateTime newExpire) {
        return Mono.just((Object)newExpire).handle((inputTime, sink) -> {
            if (newExpire.isBefore(ZonedDateTime.now(this.clock))) {
                sink.error((Throwable)new ExpireTimeInvalidException((ZonedDateTime)inputTime, "expires must be greater than now"));
            }
        }).then(Mono.justOrEmpty((Object)((PushSubscription)this.table.get((Object)username, (Object)id))).mapNotNull(pushSubscription -> {
            PushSubscription value = pushSubscription.withExpires(PushSubscriptionHelpers.evaluateExpiresTime(Optional.of(newExpire), this.clock));
            this.table.put((Object)username, (Object)id, (Object)value);
            return value;
        }).map(PushSubscription::expires).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))));
    }

    @Override
    public Publisher<Void> updateTypes(Username username, PushSubscriptionId id, Set<TypeName> types) {
        return Mono.justOrEmpty((Object)((PushSubscription)this.table.get((Object)username, (Object)id))).doOnNext(pushSubscription -> {
            PushSubscription newPushSubscription = pushSubscription.withTypes((Seq<TypeName>)CollectionConverters.asScala((Set)types).toSeq());
            this.table.put((Object)username, (Object)id, (Object)newPushSubscription);
        }).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))).then();
    }

    @Override
    public Publisher<Void> revoke(Username username, PushSubscriptionId id) {
        return Mono.fromCallable(() -> (PushSubscription)this.table.remove((Object)username, (Object)id)).then();
    }

    @Override
    public Publisher<Void> delete(Username username) {
        return Mono.fromCallable(() -> (Map)this.table.rowMap().remove(username)).then();
    }

    @Override
    public Publisher<PushSubscription> get(Username username, Set<PushSubscriptionId> ids) {
        return Flux.fromStream(this.table.row((Object)username).entrySet().stream()).filter(entry -> ids.contains(entry.getKey())).map(Map.Entry::getValue);
    }

    @Override
    public Publisher<PushSubscription> list(Username username) {
        return Flux.fromStream(this.table.row((Object)username).entrySet().stream()).map(Map.Entry::getValue);
    }

    @Override
    public Publisher<Void> validateVerificationCode(Username username, PushSubscriptionId id) {
        return Mono.justOrEmpty((Object)((PushSubscription)this.table.get((Object)username, (Object)id))).doOnNext(pushSubscription -> {
            if (!pushSubscription.validated()) {
                PushSubscription newPushSubscription = pushSubscription.verified();
                this.table.put((Object)username, (Object)id, (Object)newPushSubscription);
            }
        }).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))).then();
    }

    private boolean isUniqueDeviceClientId(Username username, String deviceClientId) {
        return this.table.row((Object)username).values().stream().noneMatch(subscription -> subscription.deviceClientId().equals(deviceClientId));
    }
}

