/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.james.core.Username;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.StorageException;
import org.apache.james.sieverepository.file.SieveFileRepository;
import org.apache.james.sieverepository.lib.SieveRepositoryContract;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SieveFileRepositoryTest
implements SieveRepositoryContract {
    static final String SIEVE_ROOT = "file://sieve";
    FileSystem fileSystem;
    SieveRepository sieveRepository;

    SieveFileRepositoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.fileSystem = new FileSystem(this){

            public File getBasedir() {
                return new File(System.getProperty("java.io.tmpdir"));
            }

            public InputStream getResource(String url) throws IOException {
                return new FileInputStream(this.getFile(url));
            }

            public File getFile(String fileURL) {
                return new File(this.getBasedir(), fileURL.substring("file://".length()));
            }
        };
        this.sieveRepository = new SieveFileRepository(this.fileSystem);
    }

    @AfterEach
    void tearDown() throws Exception {
        File root = this.fileSystem.getFile(SIEVE_ROOT);
        if (root.exists()) {
            FileUtils.forceDelete((File)root);
        }
    }

    public SieveRepository sieveRepository() {
        return this.sieveRepository;
    }

    @Test
    void putScriptShouldThrowOnCraftedUsername() {
        Assertions.assertThatThrownBy(() -> this.sieveRepository().putScript(Username.of((String)"../../home/interview1/test"), SCRIPT_NAME, SCRIPT_CONTENT)).isInstanceOf(StorageException.class);
    }

    @Test
    void putScriptShouldThrowOnCraftedScriptName() {
        Assertions.assertThatThrownBy(() -> this.sieveRepository().putScript(Username.of((String)"test"), new ScriptName("../../../../home/interview1/script"), SCRIPT_CONTENT)).isInstanceOf(StorageException.class);
    }

    @Test
    void getScriptShouldNotAllowToReadScriptsOfOtherUsers() throws Exception {
        this.sieveRepository().putScript(Username.of((String)"other"), new ScriptName("script"), new ScriptContent("PWND!!!"));
        Assertions.assertThatThrownBy(() -> this.sieveRepository().getScript(Username.of((String)"test"), new ScriptName("../other/script"))).isInstanceOf(StorageException.class);
    }

    @Test
    void getScriptShouldNotAllowToReadScriptsOfOtherUsersWhenPrefix() throws Exception {
        this.sieveRepository().putScript(Username.of((String)"testa"), new ScriptName("script"), new ScriptContent("PWND!!!"));
        Assertions.assertThatThrownBy(() -> this.sieveRepository().getScript(Username.of((String)"test"), new ScriptName("../other/script"))).isInstanceOf(StorageException.class);
    }
}

