/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository;

import java.io.IOException;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.mock.MockFileSystem;
import org.apache.james.mailrepository.MailRepositoryContract;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.file.FileMailRepository;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FileMailRepositoryTest {

    @Nested
    @DisplayName(value="Fifo no cache configuration")
    public class FifoNoCacheFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        public FifoNoCacheFileMailRepositoryTest(FileMailRepositoryTest this$0) {
            super(this$0);
        }

        @Override
        protected BaseHierarchicalConfiguration withConfigurationOptions(BaseHierarchicalConfiguration configuration) {
            configuration.addProperty("[@FIFO]", (Object)"true");
            configuration.addProperty("[@CACHEKEYS]", (Object)"false");
            return configuration;
        }
    }

    @Nested
    @DisplayName(value="Fifo configuration")
    public class FifoFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        public FifoFileMailRepositoryTest(FileMailRepositoryTest this$0) {
            super(this$0);
        }

        @Override
        protected BaseHierarchicalConfiguration withConfigurationOptions(BaseHierarchicalConfiguration configuration) {
            configuration.addProperty("[@FIFO]", (Object)"true");
            configuration.addProperty("[@CACHEKEYS]", (Object)"true");
            return configuration;
        }
    }

    @Nested
    @DisplayName(value="No cache configuration")
    public class NoCacheFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        public NoCacheFileMailRepositoryTest(FileMailRepositoryTest this$0) {
            super(this$0);
        }

        @Override
        protected BaseHierarchicalConfiguration withConfigurationOptions(BaseHierarchicalConfiguration configuration) {
            configuration.addProperty("[@FIFO]", (Object)"false");
            configuration.addProperty("[@CACHEKEYS]", (Object)"false");
            return configuration;
        }
    }

    @Nested
    @DisplayName(value="Default configuration")
    class AccessTest {
        private FileMailRepository mailRepository;
        private MockFileSystem filesystem;

        AccessTest(FileMailRepositoryTest this$0) {
        }

        @BeforeEach
        void init() throws Exception {
            this.filesystem = new MockFileSystem();
            this.mailRepository = new FileMailRepository();
            this.mailRepository.setFileSystem((FileSystem)this.filesystem);
        }

        protected BaseHierarchicalConfiguration getConfiguration() {
            BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
            configuration.addProperty("[@destinationURL]", (Object)"file://../../trying/a/location/of/james/root");
            return this.withConfigurationOptions(configuration);
        }

        protected BaseHierarchicalConfiguration withConfigurationOptions(BaseHierarchicalConfiguration configuration) {
            configuration.addProperty("[@FIFO]", (Object)"false");
            configuration.addProperty("[@CACHEKEYS]", (Object)"true");
            return configuration;
        }

        @AfterEach
        void tearDown() {
            this.filesystem.clear();
        }

        @Test
        void repositoriesOutsideOfJamesRootShouldBeRejected() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                this.mailRepository.configure((HierarchicalConfiguration)this.getConfiguration());
                this.mailRepository.init();
            }).isInstanceOf(ConfigurationException.class)).hasCauseInstanceOf(IOException.class).extracting(Throwable::getCause).satisfies(new ThrowingConsumer[]{e -> e.getMessage().startsWith("file://../../trying/a/location/of/james/root jail break outside of ")});
        }
    }

    @Nested
    @DisplayName(value="Default configuration")
    public class DefaultFileMailRepositoryTest
    extends GenericFileMailRepositoryTest {
        public DefaultFileMailRepositoryTest(FileMailRepositoryTest this$0) {
            super(this$0);
        }

        @Override
        protected BaseHierarchicalConfiguration withConfigurationOptions(BaseHierarchicalConfiguration configuration) {
            configuration.addProperty("[@FIFO]", (Object)"false");
            configuration.addProperty("[@CACHEKEYS]", (Object)"true");
            return configuration;
        }
    }

    public abstract class GenericFileMailRepositoryTest
    implements MailRepositoryContract {
        private FileMailRepository mailRepository;
        protected MockFileSystem filesystem;

        public GenericFileMailRepositoryTest(FileMailRepositoryTest this$0) {
        }

        @BeforeEach
        void init() throws Exception {
            this.filesystem = new MockFileSystem();
            this.mailRepository = new FileMailRepository();
            this.mailRepository.setFileSystem((FileSystem)this.filesystem);
            this.mailRepository.configure((HierarchicalConfiguration)this.getConfiguration(MailRepositoryUrl.from((String)"file://target/var/mailRepository")));
            this.mailRepository.init();
        }

        public MailRepository retrieveRepository(MailRepositoryPath url) throws Exception {
            FileMailRepository mailRepository = new FileMailRepository();
            mailRepository.setFileSystem((FileSystem)this.filesystem);
            mailRepository.configure((HierarchicalConfiguration)this.getConfiguration(MailRepositoryUrl.fromPathAndProtocol((Protocol)new Protocol("file"), (MailRepositoryPath)url)));
            mailRepository.init();
            return mailRepository;
        }

        protected BaseHierarchicalConfiguration getConfiguration(MailRepositoryUrl url) {
            BaseHierarchicalConfiguration configuration = new BaseHierarchicalConfiguration();
            configuration.addProperty("[@destinationURL]", (Object)url.asString());
            return this.withConfigurationOptions(configuration);
        }

        protected abstract BaseHierarchicalConfiguration withConfigurationOptions(BaseHierarchicalConfiguration var1);

        @AfterEach
        void tearDown() {
            this.filesystem.clear();
        }

        public MailRepository retrieveRepository() {
            return this.mailRepository;
        }
    }
}

