/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.xml;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.mock.MockDNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.xml.XMLDomainList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class XMLDomainListTest {
    static final Domain DEFAULT_DOMAIN = Domain.of((String)"default.domain");
    static final Domain DOMAIN_1 = Domain.of((String)"domain1");

    XMLDomainListTest() {
    }

    private DNSService setUpDNSServer(final String hostName) {
        return new MockDNSService(this){

            public String getHostName(InetAddress inet) {
                return hostName;
            }

            public Collection<InetAddress> getAllByName(String name) throws UnknownHostException {
                return ImmutableList.of((Object)InetAddress.getByName("127.0.0.1"));
            }

            public InetAddress getLocalHost() throws UnknownHostException {
                return InetAddress.getLocalHost();
            }
        };
    }

    @Test
    void testNoConfiguredDomains() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("localhost"));
        dom.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).containsOnly((Object[])new Domain[]{DEFAULT_DOMAIN});
    }

    @Test
    void testGetDomains() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("localhost"));
        dom.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).addConfiguredDomains(new Domain[]{Domain.of((String)"domain1"), Domain.of((String)"domain2")}).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).hasSize(3);
    }

    @Test
    void testGetDomainsAutoDetectNotLocalHost() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("local"));
        dom.configure(DomainListConfiguration.builder().autoDetect(true).autoDetectIp(false).addConfiguredDomains(new Domain[]{Domain.of((String)"domain1")}).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).contains((Object[])new Domain[]{Domain.of((String)"local")});
    }

    @Test
    void testGetDomainsAutoDetectLocalHost() throws Exception {
        XMLDomainList dom = new XMLDomainList(this.setUpDNSServer("localhost"));
        dom.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).addConfiguredDomains(new Domain[]{Domain.of((String)"domain1")}).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThat((List)dom.getDomains()).hasSize(2);
    }

    @Test
    void addDomainShouldFailWhenAlreadyConfigured() throws Exception {
        XMLDomainList testee = new XMLDomainList(this.setUpDNSServer("hostname"));
        testee.configure(DomainListConfiguration.builder().autoDetect(true).autoDetectIp(false).addConfiguredDomain(DOMAIN_1).defaultDomain(DEFAULT_DOMAIN));
        Assertions.assertThatThrownBy(() -> testee.addDomain(Domain.of((String)"newDomain"))).isInstanceOf(DomainListException.class);
    }

    @Test
    void removeDomainShouldFailWhenAlreadyConfigured() throws Exception {
        XMLDomainList testee = new XMLDomainList(this.setUpDNSServer("localhost"));
        testee.configure(DomainListConfiguration.builder().autoDetect(true).autoDetectIp(false).addConfiguredDomain(DOMAIN_1));
        Assertions.assertThatThrownBy(() -> testee.removeDomain(Domain.of((String)"newDomain"))).isInstanceOf(DomainListException.class);
    }

    @Test
    void configureShouldNotFailWhenConfiguringDefaultDomain() throws Exception {
        XMLDomainList testee = new XMLDomainList(this.setUpDNSServer("localhost"));
        testee.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).defaultDomain(Domain.LOCALHOST).addConfiguredDomain(DOMAIN_1));
        Assertions.assertThat((List)testee.getDomainListInternal()).containsOnly((Object[])new Domain[]{DOMAIN_1, Domain.LOCALHOST});
    }
}

