/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.examples.imap;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Properties;
import org.apache.james.examples.imap.PingImapPackages;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.base.AbstractProcessor;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public class PingProcessor
extends AbstractProcessor<PingImapPackages.PingRequest>
implements CapabilityImplementingProcessor {
    private final StatusResponseFactory factory;
    private String pongResponse;

    @Inject
    public PingProcessor(StatusResponseFactory factory) {
        super(PingImapPackages.PingRequest.class);
        this.factory = factory;
    }

    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return ImmutableList.of((Object)Capability.of((String)"PING"));
    }

    public void configure(ImapConfiguration imapConfiguration) {
        Properties customProperties = imapConfiguration.getCustomProperties();
        this.pongResponse = (String)customProperties.getOrDefault((Object)"pong.response", "completed.");
    }

    protected Mono<Void> doProcess(PingImapPackages.PingRequest request, ImapProcessor.Responder responder, ImapSession session) {
        return Mono.fromRunnable(() -> responder.respond((ImapResponseMessage)new PingImapPackages.PingResponse())).then(Mono.fromRunnable(() -> responder.respond((ImapResponseMessage)this.factory.taggedOk(request.getTag(), request.getCommand(), new HumanReadableText("org.apache.james.imap.COMPLETED", this.pongResponse)))));
    }

    protected MDCBuilder mdc(PingImapPackages.PingRequest message) {
        return MDCBuilder.create().addToContext("action", "PING");
    }
}

