/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.distributed;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.backends.cassandra.StatementRecorder;
import org.apache.james.backends.cassandra.TestingSession;
import org.apache.james.backends.cassandra.init.SessionWithInitializedTablesFactory;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.JmapGuiceProbe;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.GuiceProbe;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class ReadLevelTest {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().cassandra().disableCache().deduplication().noCryptoConfig()).build()).extension((GuiceModuleTestExtension)new DockerOpenSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()}).overrideWith(new Module[]{new TestingSessionModule()})).build();
    private MessageId messageId;

    ReadLevelTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture.DOMAIN().asString()).addUser(Fixture.BOB().asString(), Fixture.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture.baseRequestSpecBuilder((GuiceJamesServer)server).setAuth((AuthenticationScheme)Fixture.authScheme((UserCredential)new UserCredential(Fixture.BOB(), Fixture.BOB_PASSWORD()))).build();
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture.BOB()));
        this.messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture.BOB().asString(), MailboxPath.inbox((Username)Fixture.BOB()), MessageManager.AppendCommand.from((Message)this.createMessage())).getMessageId();
        Thread.sleep(1000L);
    }

    @Test
    void gettingEmailMetadataShouldNotReadBlobs(GuiceJamesServer server) {
        StatementRecorder statementRecorder = new StatementRecorder();
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().recordStatements(statementRecorder);
        String request = "{  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],  \"methodCalls\": [[    \"Email/get\",    {      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",      \"ids\": [\"" + this.messageId.serialize() + "\"],      \"properties\": [\"id\", \"size\", \"mailboxIds\", \"mailboxIds\", \"blobId\",                        \"threadId\", \"receivedAt\"]    },    \"c1\"]]} ";
        RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).post();
        Assertions.assertThat((List)statementRecorder.listExecutedStatements(StatementRecorder.Selector.preparedStatementStartingWith((String)"SELECT * FROM blobs"))).hasSize(0);
    }

    @Test
    void gettingEmailHeadersShouldReadBlobOnce(GuiceJamesServer server) {
        StatementRecorder statementRecorder = new StatementRecorder();
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().recordStatements(statementRecorder);
        String request = "{  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],  \"methodCalls\": [[    \"Email/get\",    {      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",      \"ids\": [\"" + this.messageId.serialize() + "\"],      \"properties\": [\"id\", \"size\", \"mailboxIds\", \"mailboxIds\", \"blobId\",                        \"threadId\", \"receivedAt\",  \"messageId\", \"inReplyTo\",                        \"references\", \"to\", \"cc\", \"bcc\", \"from\", \"sender\",                        \"replyTo\", \"subject\", \"headers\", \"header:anything\"]    },    \"c1\"]]} ";
        RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).post();
        Assertions.assertThat((List)statementRecorder.listExecutedStatements(StatementRecorder.Selector.preparedStatementStartingWith((String)"SELECT * FROM blobs"))).hasSize(1);
    }

    @Test
    void gettingEmailFastViewShouldReadBlobOnce(GuiceJamesServer server) {
        StatementRecorder statementRecorder = new StatementRecorder();
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().recordStatements(statementRecorder);
        String request = "{  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],  \"methodCalls\": [[    \"Email/get\",    {      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",      \"ids\": [\"" + this.messageId.serialize() + "\"],      \"properties\": [\"id\", \"size\", \"mailboxIds\", \"mailboxIds\", \"blobId\",                        \"threadId\", \"receivedAt\",  \"messageId\", \"inReplyTo\",                        \"references\", \"to\", \"cc\", \"bcc\", \"from\", \"sender\",                        \"replyTo\", \"subject\", \"headers\", \"header:anything\",                        \"preview\", \"hasAttachment\"]    },    \"c1\"]]} ";
        RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).post();
        Assertions.assertThat((List)statementRecorder.listExecutedStatements(StatementRecorder.Selector.preparedStatementStartingWith((String)"SELECT * FROM blobs"))).hasSize(1);
    }

    @Test
    void gettingEmailFastViewShouldReadBlobTwiceUponCacheMisses(GuiceJamesServer server) {
        ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).clearMessageFastViewProjection();
        StatementRecorder statementRecorder = new StatementRecorder();
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().recordStatements(statementRecorder);
        String request = "{  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],  \"methodCalls\": [[    \"Email/get\",    {      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",      \"ids\": [\"" + this.messageId.serialize() + "\"],      \"properties\": [\"id\", \"size\", \"mailboxIds\", \"mailboxIds\", \"blobId\",                        \"threadId\", \"receivedAt\",  \"messageId\", \"inReplyTo\",                        \"references\", \"to\", \"cc\", \"bcc\", \"from\", \"sender\",                        \"replyTo\", \"subject\", \"headers\", \"header:anything\",                        \"preview\", \"hasAttachment\"]    },    \"c1\"]]} ";
        RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).post();
        Assertions.assertThat((List)statementRecorder.listExecutedStatements(StatementRecorder.Selector.preparedStatementStartingWith((String)"SELECT * FROM blobs"))).hasSize(2);
    }

    @Test
    void previewMissesShouldPopulateTheProjection(GuiceJamesServer server) {
        ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).clearMessageFastViewProjection();
        String request = "{  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],  \"methodCalls\": [[    \"Email/get\",    {      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",      \"ids\": [\"" + this.messageId.serialize() + "\"],      \"properties\": [\"id\", \"size\", \"mailboxIds\", \"mailboxIds\", \"blobId\",                        \"threadId\", \"receivedAt\",  \"messageId\", \"inReplyTo\",                        \"references\", \"to\", \"cc\", \"bcc\", \"from\", \"sender\",                        \"replyTo\", \"subject\", \"headers\", \"header:anything\",                        \"preview\", \"hasAttachment\"]    },    \"c1\"]]} ";
        ((ValidatableResponse)((Response)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).post()).then()).statusCode(200);
        StatementRecorder statementRecorder = new StatementRecorder();
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().recordStatements(statementRecorder);
        RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).post();
        Assertions.assertThat((List)statementRecorder.listExecutedStatements(StatementRecorder.Selector.preparedStatementStartingWith((String)"SELECT * FROM blobs"))).hasSize(1);
    }

    @Test
    void gettingEmailBodyShouldReadBlobTwice(GuiceJamesServer server) {
        StatementRecorder statementRecorder = new StatementRecorder();
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().recordStatements(statementRecorder);
        String request = "{  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],  \"methodCalls\": [[    \"Email/get\",    {      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",      \"ids\": [\"" + this.messageId.serialize() + "\"],      \"properties\": [\"id\", \"size\", \"mailboxIds\", \"mailboxIds\", \"blobId\",                        \"threadId\", \"receivedAt\",  \"messageId\", \"inReplyTo\",                        \"references\", \"to\", \"cc\", \"bcc\", \"from\", \"sender\",                        \"replyTo\", \"subject\", \"headers\", \"header:anything\",                        \"preview\", \"hasAttachment\", \"bodyStructure\", \"textBody\", \"htmlBody\",\n                       \"attachments\", \"bodyValues\"]    },    \"c1\"]]} ";
        RestAssured.with().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).post();
        Assertions.assertThat((List)statementRecorder.listExecutedStatements(StatementRecorder.Selector.preparedStatementStartingWith((String)"SELECT * FROM blobs"))).hasSize(2);
    }

    private Message createMessage() throws Exception {
        return Message.Builder.of().setSubject("test").setSender(Fixture.ANDRE().asString()).setFrom(Fixture.ANDRE().asString()).setSubject("World domination \r\n and this is also part of the header").setBody("testmail", StandardCharsets.UTF_8).build();
    }

    private static class TestingSessionProbe
    implements GuiceProbe {
        private final TestingSession testingSession;

        @Inject
        private TestingSessionProbe(TestingSession testingSession) {
            this.testingSession = testingSession;
        }

        public TestingSession getTestingSession() {
            return this.testingSession;
        }
    }

    private static class TestingSessionModule
    extends AbstractModule {
        private TestingSessionModule() {
        }

        protected void configure() {
            Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(TestingSessionProbe.class);
            this.bind(CqlSession.class).to(TestingSession.class);
        }

        @Provides
        @Singleton
        TestingSession provideSession(SessionWithInitializedTablesFactory factory) {
            return new TestingSession(factory.get());
        }
    }
}

