/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.distributed;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.inject.Module;
import java.util.UUID;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerOpenSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.jmap.rfc8621.contract.EmailSetMethodContract;
import org.apache.james.jmap.rfc8621.contract.probe.DelegationProbeModule;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class DistributedEmailSetMethodTest
implements EmailSetMethodContract {
    public static final DockerOpenSearchExtension ELASTIC_SEARCH_EXTENSION = new DockerOpenSearchExtension();
    public static final CassandraMessageId.Factory MESSAGE_ID_FACTORY = new CassandraMessageId.Factory();
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).build()).extension((GuiceModuleTestExtension)ELASTIC_SEARCH_EXTENSION).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule(), new DelegationProbeModule()})).build();

    public MessageId randomMessageId() {
        return CassandraMessageId.Factory.of((UUID)Uuids.timeBased());
    }

    public String invalidMessageIdMessage(String invalid) {
        return String.format("Invalid UUID string: %s", invalid);
    }

    @Test
    @Disabled(value="Distributed event bus is asynchronous, we cannot expect the newState to be returned immediately after Email/set call")
    public void newStateShouldBeUpToDate(GuiceJamesServer server) {
    }

    @Test
    @Disabled(value="Distributed event bus is asynchronous, we cannot expect the newState to be returned immediately after Email/set call")
    public void oldStateShouldIncludeSetChanges(GuiceJamesServer server) {
    }
}

