/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.DockerCassandra;
import org.apache.james.events.CassandraEventDeadLetters;
import org.apache.james.events.CassandraEventDeadLettersDAO;
import org.apache.james.events.CassandraEventDeadLettersGroupDAO;
import org.apache.james.events.CassandraEventDeadLettersModule;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventDeadLettersHealthCheck;
import org.apache.james.events.EventDeadLettersHealthCheckContract;
import org.apache.james.events.EventSerializer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraEventDeadLettersHealthCheckTest
implements EventDeadLettersHealthCheckContract {
    @RegisterExtension
    static CassandraClusterExtension cassandraClusterExtension = new CassandraClusterExtension(CassandraEventDeadLettersModule.MODULE);
    private EventDeadLettersHealthCheck testee;
    private CassandraEventDeadLetters eventDeadLetters;
    private DockerCassandra dockerCassandra;

    CassandraEventDeadLettersHealthCheckTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandraCluster, DockerCassandra dockerCassandra) {
        EventBusTestFixture.TestEventSerializer eventSerializer = new EventBusTestFixture.TestEventSerializer();
        this.eventDeadLetters = new CassandraEventDeadLetters(new CassandraEventDeadLettersDAO((CqlSession)cassandraCluster.getConf(), (EventSerializer)eventSerializer), new CassandraEventDeadLettersGroupDAO((CqlSession)cassandraCluster.getConf()));
        this.testee = new EventDeadLettersHealthCheck((EventDeadLetters)this.eventDeadLetters);
        this.dockerCassandra = dockerCassandra;
    }

    public EventDeadLettersHealthCheck testee() {
        return this.testee;
    }

    public EventDeadLetters eventDeadLetters() {
        return this.eventDeadLetters;
    }

    public void createErrorWhenDoingHealthCheck() {
        this.dockerCassandra.pause();
    }

    public void resolveErrorWhenDoingHealthCheck() {
        this.dockerCassandra.unpause();
    }
}

