/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.List;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.events.CassandraEventDeadLettersGroupDAO;
import org.apache.james.events.CassandraEventDeadLettersModule;
import org.apache.james.events.EventDeadLettersContract;
import org.apache.james.events.Group;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraEventDeadLettersGroupDAOTest {
    @RegisterExtension
    static CassandraClusterExtension cassandraClusterExtension = new CassandraClusterExtension(CassandraEventDeadLettersModule.MODULE);
    private static CassandraEventDeadLettersGroupDAO GROUP_DAO;

    CassandraEventDeadLettersGroupDAOTest() {
    }

    @BeforeAll
    static void setUp(CassandraCluster cassandraCluster) {
        GROUP_DAO = new CassandraEventDeadLettersGroupDAO((CqlSession)cassandraCluster.getConf());
    }

    @Test
    void retrieveAllGroupsShouldReturnEmptyWhenDefault() {
        Assertions.assertThat((List)((List)GROUP_DAO.retrieveAllGroups().collectList().block())).isEmpty();
    }

    @Test
    void retrieveAllGroupsShouldReturnStoredGroups() {
        GROUP_DAO.storeGroup(EventDeadLettersContract.GROUP_A).block();
        GROUP_DAO.storeGroup(EventDeadLettersContract.GROUP_B).block();
        Assertions.assertThat((List)((List)GROUP_DAO.retrieveAllGroups().collectList().block())).containsOnly((Object[])new Group[]{EventDeadLettersContract.GROUP_A, EventDeadLettersContract.GROUP_B});
    }

    @Test
    void deleteGroupShouldOnlyDeleteMatchedGroup() {
        GROUP_DAO.storeGroup(EventDeadLettersContract.GROUP_A).block();
        GROUP_DAO.storeGroup(EventDeadLettersContract.GROUP_B).block();
        GROUP_DAO.deleteGroup(EventDeadLettersContract.GROUP_A).block();
        Assertions.assertThat((List)((List)GROUP_DAO.retrieveAllGroups().collectList().block())).containsOnly((Object[])new Group[]{EventDeadLettersContract.GROUP_B});
    }
}

