/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.List;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.events.CassandraEventDeadLettersDAO;
import org.apache.james.events.CassandraEventDeadLettersModule;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventDeadLettersContract;
import org.apache.james.events.EventSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraEventDeadLettersDAOTest {
    @RegisterExtension
    static CassandraClusterExtension cassandraClusterExtension = new CassandraClusterExtension(CassandraEventDeadLettersModule.MODULE);
    private CassandraEventDeadLettersDAO cassandraEventDeadLettersDAO;

    CassandraEventDeadLettersDAOTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandraCluster) {
        EventBusTestFixture.TestEventSerializer eventSerializer = new EventBusTestFixture.TestEventSerializer();
        this.cassandraEventDeadLettersDAO = new CassandraEventDeadLettersDAO((CqlSession)cassandraCluster.getConf(), (EventSerializer)eventSerializer);
    }

    @Test
    void removeEventShouldSucceededWhenRemoveStoredEvent() {
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_A, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_1).block();
        this.cassandraEventDeadLettersDAO.removeEvent(EventDeadLettersContract.GROUP_A, EventDeadLettersContract.INSERTION_ID_1).block();
        Assertions.assertThat((List)((List)this.cassandraEventDeadLettersDAO.retrieveInsertionIdsWithGroup(EventDeadLettersContract.GROUP_A).collectList().block())).isEmpty();
    }

    @Test
    void removeAllEventsOfAGroupShouldWork() {
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_A, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_1).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_A, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_2).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_A, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_3).block();
        this.cassandraEventDeadLettersDAO.removeEvents(EventDeadLettersContract.GROUP_A).block();
        Assertions.assertThat((List)((List)this.cassandraEventDeadLettersDAO.retrieveInsertionIdsWithGroup(EventDeadLettersContract.GROUP_A).collectList().block())).isEmpty();
    }

    @Test
    void retrieveFailedEventShouldReturnEmptyWhenDefault() {
        Assertions.assertThat((boolean)this.cassandraEventDeadLettersDAO.retrieveFailedEvent(EventDeadLettersContract.GROUP_A, EventDeadLettersContract.INSERTION_ID_1).blockOptional().isPresent()).isFalse();
    }

    @Test
    void retrieveFailedEventShouldReturnStoredEvent() {
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_A, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_1).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_2, EventDeadLettersContract.INSERTION_ID_2).block();
        Assertions.assertThat((Object)((Event)this.cassandraEventDeadLettersDAO.retrieveFailedEvent(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.INSERTION_ID_2).blockOptional().get())).isEqualTo((Object)EventDeadLettersContract.EVENT_2);
    }

    @Test
    void retrieveInsertionIdsWithGroupShouldReturnEmptyWhenDefault() {
        Assertions.assertThat((List)((List)this.cassandraEventDeadLettersDAO.retrieveInsertionIdsWithGroup(EventDeadLettersContract.GROUP_A).collectList().block())).isEmpty();
    }

    @Test
    void retrieveInsertionIdsWithGroupShouldReturnStoredInsertionId() {
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_1).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_2, EventDeadLettersContract.INSERTION_ID_2).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_3, EventDeadLettersContract.INSERTION_ID_3).block();
        Assertions.assertThat((List)((List)this.cassandraEventDeadLettersDAO.retrieveInsertionIdsWithGroup(EventDeadLettersContract.GROUP_B).collectList().block())).containsOnly((Object[])new EventDeadLetters.InsertionId[]{EventDeadLettersContract.INSERTION_ID_1, EventDeadLettersContract.INSERTION_ID_2, EventDeadLettersContract.INSERTION_ID_3});
    }

    @Test
    void shouldReturnTrueWhenEventStored() {
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_1).block();
        Assertions.assertThat((Boolean)((Boolean)this.cassandraEventDeadLettersDAO.containEvents().block())).isTrue();
    }

    @Test
    void shouldReturnTrueWhenNoEventStored() {
        Assertions.assertThat((Boolean)((Boolean)this.cassandraEventDeadLettersDAO.containEvents().block())).isFalse();
    }

    @Test
    void shouldReturnTrueWhenEventsStoredAndRemovedSome() {
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_1).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_2).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_3).block();
        Assertions.assertThat((Boolean)((Boolean)this.cassandraEventDeadLettersDAO.containEvents().block())).isTrue();
        this.cassandraEventDeadLettersDAO.removeEvent(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.INSERTION_ID_3).block();
        Assertions.assertThat((Boolean)((Boolean)this.cassandraEventDeadLettersDAO.containEvents().block())).isTrue();
    }

    @Test
    void shouldReturnFalseWhenRemovedAllEventsStored() {
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_1).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_2).block();
        this.cassandraEventDeadLettersDAO.store(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.EVENT_1, EventDeadLettersContract.INSERTION_ID_3).block();
        Assertions.assertThat((Boolean)((Boolean)this.cassandraEventDeadLettersDAO.containEvents().block())).isTrue();
        this.cassandraEventDeadLettersDAO.removeEvent(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.INSERTION_ID_3).block();
        this.cassandraEventDeadLettersDAO.removeEvent(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.INSERTION_ID_2).block();
        this.cassandraEventDeadLettersDAO.removeEvent(EventDeadLettersContract.GROUP_B, EventDeadLettersContract.INSERTION_ID_1).block();
        Assertions.assertThat((Boolean)((Boolean)this.cassandraEventDeadLettersDAO.containEvents().block())).isFalse();
    }
}

