/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.time.Instant;
import java.util.Set;
import org.apache.james.JsonSerializationVerifier;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.PlainBlobId;
import org.apache.james.json.DTOModule;
import org.apache.james.json.JsonGenericSerializer;
import org.apache.james.server.blob.deduplication.BlobGCTask;
import org.apache.james.server.blob.deduplication.BlobGCTaskDTO;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.UpdatableTickingClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BlobGCTaskSerializationTest {
    BlobStoreDAO blobStoreDAO;
    GenerationAwareBlobId.Factory generationAwareBlobIdFactory;
    GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration;
    Set<BlobReferenceSource> blobReferenceSources;
    Clock clock;

    BlobGCTaskSerializationTest() {
    }

    @BeforeEach
    void setUp() {
        this.blobStoreDAO = (BlobStoreDAO)Mockito.mock(BlobStoreDAO.class);
        this.blobReferenceSources = ImmutableSet.of((Object)((BlobReferenceSource)Mockito.mock(BlobReferenceSource.class)));
        this.clock = new UpdatableTickingClock(Instant.parse("2007-12-03T10:15:30.00Z"));
        this.generationAwareBlobIdConfiguration = GenerationAwareBlobId.Configuration.DEFAULT;
        this.generationAwareBlobIdFactory = new GenerationAwareBlobId.Factory(this.clock, (BlobId.Factory)new PlainBlobId.Factory(), this.generationAwareBlobIdConfiguration);
    }

    @Test
    void shouldMatchJsonSerializationContract() throws Exception {
        JsonSerializationVerifier.dtoModule((DTOModule)BlobGCTaskDTO.module((BlobStoreDAO)this.blobStoreDAO, (GenerationAwareBlobId.Factory)this.generationAwareBlobIdFactory, (GenerationAwareBlobId.Configuration)this.generationAwareBlobIdConfiguration, this.blobReferenceSources, (Clock)this.clock)).bean((Object)new BlobGCTask(this.blobStoreDAO, this.generationAwareBlobIdFactory, this.generationAwareBlobIdConfiguration, this.blobReferenceSources, BucketName.DEFAULT, this.clock, 99, 100, 0.8)).json(ClassLoaderUtils.getSystemResourceAsString((String)"json/blobGC.task.json")).verify();
    }

    @Test
    void shouldDeserializeLegacyData() throws Exception {
        BlobGCTask gcTask = (BlobGCTask)JsonGenericSerializer.forModules((DTOModule[])new DTOModule[]{BlobGCTaskDTO.module((BlobStoreDAO)this.blobStoreDAO, (GenerationAwareBlobId.Factory)this.generationAwareBlobIdFactory, (GenerationAwareBlobId.Configuration)this.generationAwareBlobIdConfiguration, this.blobReferenceSources, (Clock)this.clock)}).withoutNestedType().deserialize(ClassLoaderUtils.getSystemResourceAsString((String)"json/blobGC-legacy.task.json"));
        Assertions.assertThat((Object)gcTask).usingRecursiveComparison(JsonSerializationVerifier.recursiveComparisonConfiguration).isEqualTo((Object)new BlobGCTask(this.blobStoreDAO, this.generationAwareBlobIdFactory, this.generationAwareBlobIdConfiguration, this.blobReferenceSources, BucketName.DEFAULT, this.clock, 99, 1000, 0.8));
    }
}

