/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import java.net.URI;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

public class AwsS3AuthConfigurationTest {
    private static final URI ENDPOINT = URI.create("http://myEndpoint");
    private static final String ACCESS_KEY_ID = "myAccessKeyId";
    private static final String SECRET_KEY = "mySecretKey";
    private static final String TRUST_STORE_PATH = "/where/ever/truststore.p12";
    private static final String TRUST_STORE_TYPE = "PKCS12";
    private static final String TRUST_STORE_SECRET = "myTrustStoreSecret";
    private static final String TRUST_STORE_ALGORITHM = "myTrustStoreAlgorithm";

    @Test
    public void credentialsShouldRespectBeanContract() {
        EqualsVerifier.forClass(AwsS3AuthConfiguration.class).verify();
    }

    @Test
    public void builderShouldThrowWhenEndpointIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AwsS3AuthConfiguration.builder().endpoint(null).accessKeyId(ACCESS_KEY_ID).secretKey(SECRET_KEY).build()).isInstanceOf(NullPointerException.class)).hasMessage("'endpoint' is mandatory");
    }

    @Test
    public void builderShouldThrowWhenAccessKeyIdIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AwsS3AuthConfiguration.builder().endpoint(ENDPOINT).accessKeyId(null).secretKey(SECRET_KEY).build()).isInstanceOf(NullPointerException.class)).hasMessage("'accessKeyId' is mandatory");
    }

    @Test
    public void builderShouldThrowWhenAccessKeyIdIsEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AwsS3AuthConfiguration.builder().endpoint(ENDPOINT).accessKeyId("").secretKey(SECRET_KEY).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("'accessKeyId' is mandatory");
    }

    @Test
    public void builderShouldThrowWhenSecretKeyIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AwsS3AuthConfiguration.builder().endpoint(ENDPOINT).accessKeyId(ACCESS_KEY_ID).secretKey(null).build()).isInstanceOf(NullPointerException.class)).hasMessage("'secretKey' is mandatory");
    }

    @Test
    public void builderShouldThrowWhenSecretKeyIsEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AwsS3AuthConfiguration.builder().endpoint(ENDPOINT).accessKeyId(ACCESS_KEY_ID).secretKey("").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("'secretKey' is mandatory");
    }

    @Test
    public void builderShouldWork() {
        AwsS3AuthConfiguration configuration = AwsS3AuthConfiguration.builder().endpoint(ENDPOINT).accessKeyId(ACCESS_KEY_ID).secretKey(SECRET_KEY).trustStorePath(TRUST_STORE_PATH).trustStoreType(TRUST_STORE_TYPE).trustStoreSecret(TRUST_STORE_SECRET).trustStoreAlgorithm(TRUST_STORE_ALGORITHM).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.getEndpoint()).isEqualTo((Object)ENDPOINT);
            softly.assertThat(configuration.getAccessKeyId()).isEqualTo(ACCESS_KEY_ID);
            softly.assertThat(configuration.getSecretKey()).isEqualTo(SECRET_KEY);
            softly.assertThat(configuration.getTrustStorePath()).hasValue((Object)TRUST_STORE_PATH);
            softly.assertThat(configuration.getTrustStoreType()).hasValue((Object)TRUST_STORE_TYPE);
            softly.assertThat(configuration.getTrustStoreSecret()).hasValue((Object)TRUST_STORE_SECRET);
            softly.assertThat(configuration.getTrustStoreAlgorithm()).hasValue((Object)TRUST_STORE_ALGORITHM);
        });
    }

    @Test
    public void builderShouldWorkWithoutOptionals() {
        AwsS3AuthConfiguration configuration = AwsS3AuthConfiguration.builder().endpoint(ENDPOINT).accessKeyId(ACCESS_KEY_ID).secretKey(SECRET_KEY).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.getEndpoint()).isEqualTo((Object)ENDPOINT);
            softly.assertThat(configuration.getAccessKeyId()).isEqualTo(ACCESS_KEY_ID);
            softly.assertThat(configuration.getSecretKey()).isEqualTo(SECRET_KEY);
            softly.assertThat(configuration.getTrustStorePath()).isNotPresent();
            softly.assertThat(configuration.getTrustStoreType()).isNotPresent();
            softly.assertThat(configuration.getTrustStoreSecret()).isNotPresent();
            softly.assertThat(configuration.getTrustStoreAlgorithm()).isNotPresent();
        });
    }
}

