/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import java.util.List;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.memory.InMemoryEventStore;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategyCommandHandler;
import org.apache.james.modules.blobstore.validation.StorageStrategyValidationEventSourcingSystem;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class StorageStrategyValidationEventSourcingSystemTest {
    private StorageStrategyValidationEventSourcingSystem testee;
    private InMemoryEventStore eventStore;

    StorageStrategyValidationEventSourcingSystemTest() {
    }

    @BeforeEach
    void setUp() {
        this.eventStore = new InMemoryEventStore();
        this.testee = new StorageStrategyValidationEventSourcingSystem((EventStore)this.eventStore);
    }

    @Test
    void startingForTheFirstTimeShouldSucceedWhenPassThrough() {
        StartUpCheck.CheckResult checkResult = this.testee.validate(() -> StorageStrategy.PASSTHROUGH);
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.GOOD);
    }

    @Test
    void startingForTheFirstTimeShouldSucceedWhenDeduplication() {
        StartUpCheck.CheckResult checkResult = this.testee.validate(() -> StorageStrategy.DEDUPLICATION);
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.GOOD);
    }

    @Test
    void startingShouldSucceedWhenTurningOnDeduplication() {
        this.testee.validate(() -> StorageStrategy.PASSTHROUGH);
        StartUpCheck.CheckResult checkResult = this.testee.validate(() -> StorageStrategy.DEDUPLICATION);
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.GOOD);
    }

    @Test
    void startingShouldFailWhenTurningOffDeduplication() {
        this.testee.validate(() -> StorageStrategy.DEDUPLICATION);
        StartUpCheck.CheckResult checkResult = this.testee.validate(() -> StorageStrategy.PASSTHROUGH);
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.BAD);
    }

    @Test
    void validatingSeveralTimeTheSameStrategyShouldNotAddEventsToTheHistory() {
        this.testee.validate(() -> StorageStrategy.DEDUPLICATION);
        this.testee.validate(() -> StorageStrategy.DEDUPLICATION);
        History history = (History)Mono.from((Publisher)this.eventStore.getEventsOfAggregate(RegisterStorageStrategyCommandHandler.AGGREGATE_ID)).block();
        Assertions.assertThat((List)history.getEventsJava()).hasSize(1);
    }
}

