/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra.cache;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.james.blob.cassandra.cache.CassandraCacheConfiguration;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class CassandraCacheConfigurationTest {
    private static final byte[] EIGHT_KILOBYTES = Strings.repeat((String)"01234567\n", (int)1000).getBytes(StandardCharsets.UTF_8);
    private static final Duration DEFAULT_TIME_OUT = Duration.ofSeconds(50L);
    private static final int DEFAULT_THRESHOLD_SIZE_IN_BYTES = EIGHT_KILOBYTES.length;
    private static final Duration _1_SEC_TTL = Duration.ofSeconds(1L);
    private static final Duration TOO_BIG_TTL = Duration.ofSeconds(0x80000000L);
    private static final Duration NEGATIVE_TIME_OUT = Duration.ofSeconds(-50L);
    private static final Duration _2_HOURS_TIME_OUT = Duration.ofHours(2L);
    private static final int NEGATIVE_THRESHOLD_SIZE_IN_BYTES = -1 * EIGHT_KILOBYTES.length;
    private static final Duration NEGATIVE_TTL = Duration.ofSeconds(-1L);

    CassandraCacheConfigurationTest() {
    }

    @Test
    void shouldReturnTheCorrectConfigured() {
        CassandraCacheConfiguration cacheConfiguration = new CassandraCacheConfiguration.Builder().sizeThresholdInBytes(DEFAULT_THRESHOLD_SIZE_IN_BYTES).ttl(_1_SEC_TTL).build();
        SoftAssertions.assertSoftly(soflty -> {
            Assertions.assertThat((int)cacheConfiguration.getSizeThresholdInBytes()).isEqualTo(DEFAULT_THRESHOLD_SIZE_IN_BYTES);
            Assertions.assertThat((Duration)cacheConfiguration.getTtl()).isEqualTo((Object)_1_SEC_TTL);
        });
    }

    @Test
    void shouldThrowWhenConfiguredTooBigTTL() {
        Assertions.assertThatThrownBy(() -> new CassandraCacheConfiguration.Builder().sizeThresholdInBytes(DEFAULT_THRESHOLD_SIZE_IN_BYTES).ttl(TOO_BIG_TTL).build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenConfiguredNegativeTTL() {
        Assertions.assertThatThrownBy(() -> new CassandraCacheConfiguration.Builder().sizeThresholdInBytes(DEFAULT_THRESHOLD_SIZE_IN_BYTES).ttl(NEGATIVE_TTL).build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenConfiguredZeroTTL() {
        Assertions.assertThatThrownBy(() -> new CassandraCacheConfiguration.Builder().sizeThresholdInBytes(DEFAULT_THRESHOLD_SIZE_IN_BYTES).ttl(Duration.ofSeconds(0L)).build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenConfiguredNegativeThreshold() {
        Assertions.assertThatThrownBy(() -> new CassandraCacheConfiguration.Builder().sizeThresholdInBytes(NEGATIVE_THRESHOLD_SIZE_IN_BYTES).ttl(_1_SEC_TTL).build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldReturnDefaultConfigurationWhenEmpty() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        Assertions.assertThat((Object)CassandraCacheConfiguration.from((Configuration)configuration)).isEqualTo((Object)CassandraCacheConfiguration.builder().build());
    }

    @Test
    void fromShouldReturnSuppliedConfiguration() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("cache.cassandra.ttl", (Object)"3 days");
        configuration.addProperty("cache.sizeThresholdInBytes", (Object)"4 KiB");
        Assertions.assertThat((Object)CassandraCacheConfiguration.from((Configuration)configuration)).isEqualTo((Object)CassandraCacheConfiguration.builder().ttl(Duration.ofDays(3L)).sizeThresholdInBytes(4096).build());
    }
}

