/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra.cache;

import com.datastax.oss.driver.api.core.CqlSession;
import java.time.Duration;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.Scenario;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.cassandra.cache.BlobStoreCache;
import org.apache.james.blob.cassandra.cache.BlobStoreCacheContract;
import org.apache.james.blob.cassandra.cache.CassandraBlobCacheModule;
import org.apache.james.blob.cassandra.cache.CassandraBlobStoreCache;
import org.apache.james.blob.cassandra.cache.CassandraCacheConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class CassandraBlobStoreCacheTest
implements BlobStoreCacheContract {
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraBlobCacheModule.MODULE);
    private static final int DEFAULT_THRESHOLD_IN_BYTES = EIGHT_KILOBYTES.length;
    private static final Duration _2_SEC_TTL = Duration.ofSeconds(2L);
    private BlobStoreCache testee;
    private HashBlobId.Factory blobIdFactory;

    CassandraBlobStoreCacheTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.blobIdFactory = new HashBlobId.Factory();
        CassandraCacheConfiguration cacheConfiguration = new CassandraCacheConfiguration.Builder().sizeThresholdInBytes(DEFAULT_THRESHOLD_IN_BYTES).ttl(_2_SEC_TTL).build();
        this.testee = new CassandraBlobStoreCache((CqlSession)cassandra.getConf(), cacheConfiguration);
    }

    @Override
    public BlobStoreCache testee() {
        return this.testee;
    }

    @Override
    public BlobId.Factory blobIdFactory() {
        return this.blobIdFactory;
    }

    @Test
    void cacheShouldNotPropagateFailures(CassandraCluster cassandra) {
        cassandra.getConf().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO blob_cache")});
        BlobId blobId = this.blobIdFactory().randomId();
        Assertions.assertThatCode(() -> Mono.from((Publisher)this.testee.cache(blobId, EIGHT_KILOBYTES)).block()).doesNotThrowAnyException();
    }
}

