/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra.cache;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.cassandra.cache.BlobStoreCache;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface BlobStoreCacheContract {
    public static final byte[] EIGHT_KILOBYTES = Strings.repeat((String)"0123456\n", (int)1024).getBytes(StandardCharsets.UTF_8);

    public BlobStoreCache testee();

    public BlobId.Factory blobIdFactory();

    @Test
    default public void shouldSaveWhenCacheSmallByteData() {
        BlobId blobId = this.blobIdFactory().randomId();
        Assertions.assertThatCode(() -> ((Mono)Mono.from((Publisher)this.testee().cache(blobId, EIGHT_KILOBYTES))).block()).doesNotThrowAnyException();
        byte[] actual = (byte[])Mono.from((Publisher)this.testee().read(blobId)).block();
        Assertions.assertThat((byte[])actual).containsExactly(EIGHT_KILOBYTES);
    }

    @Test
    default public void shouldReturnExactlyDataWhenRead() {
        BlobId blobId = this.blobIdFactory().randomId();
        Mono.from((Publisher)this.testee().cache(blobId, EIGHT_KILOBYTES)).block();
        byte[] actual = (byte[])Mono.from((Publisher)this.testee().read(blobId)).block();
        Assertions.assertThat((byte[])actual).containsExactly(EIGHT_KILOBYTES);
    }

    @Test
    default public void shouldReturnEmptyWhenReadWithTimeOut() {
        BlobId blobId = this.blobIdFactory().randomId();
        Mono.from((Publisher)this.testee().cache(blobId, EIGHT_KILOBYTES)).block();
    }

    @Test
    default public void shouldReturnNothingWhenDelete() {
        BlobId blobId = this.blobIdFactory().randomId();
        Mono.from((Publisher)this.testee().cache(blobId, EIGHT_KILOBYTES)).block();
        Mono.from((Publisher)this.testee().remove(blobId)).block();
        Optional actual = Mono.from((Publisher)this.testee().read(blobId)).blockOptional();
        Assertions.assertThat((Optional)actual).isEmpty();
    }

    @Test
    default public void shouldDeleteExactlyAndReturnNothingWhenDelete() {
        BlobId blobId = this.blobIdFactory().randomId();
        BlobId blobId2 = this.blobIdFactory().randomId();
        Mono.from((Publisher)this.testee().cache(blobId, EIGHT_KILOBYTES)).block();
        Mono.from((Publisher)this.testee().cache(blobId2, EIGHT_KILOBYTES)).block();
        Mono.from((Publisher)this.testee().remove(blobId)).block();
        byte[] readBlobId2 = (byte[])Mono.from((Publisher)this.testee().read(blobId2)).block();
        Assertions.assertThat((byte[])readBlobId2).containsExactly(EIGHT_KILOBYTES);
    }

    @Test
    default public void shouldReturnDataWhenCacheSmallDataInConfigurationTTL() {
        BlobId blobId = this.blobIdFactory().randomId();
        Assertions.assertThatCode(() -> ((Mono)Mono.from((Publisher)this.testee().cache(blobId, EIGHT_KILOBYTES))).block()).doesNotThrowAnyException();
        Awaitility.await().atMost(Durations.ONE_SECOND).await().untilAsserted(() -> Assertions.assertThat((byte[])((byte[])Mono.from((Publisher)this.testee().read(blobId)).block())).containsExactly(EIGHT_KILOBYTES));
    }

    @Test
    default public void shouldNotReturnDataWhenCachedSmallDataOutOfConfigurationTTL() {
        BlobId blobId = this.blobIdFactory().randomId();
        Assertions.assertThatCode(() -> ((Mono)Mono.from((Publisher)this.testee().cache(blobId, EIGHT_KILOBYTES))).block()).doesNotThrowAnyException();
        Awaitility.await().atMost(Duration.ofSeconds(2L).plus(Durations.FIVE_HUNDRED_MILLISECONDS)).await().untilAsserted(() -> Assertions.assertThat((Optional)Mono.from((Publisher)this.testee().read(blobId)).blockOptional()).isEmpty());
    }

    @Test
    default public void readShouldReturnEmptyCachedByteArray() {
        BlobId blobId = this.blobIdFactory().randomId();
        byte[] emptyByteArray = new byte[]{};
        Mono.from((Publisher)this.testee().cache(blobId, emptyByteArray)).block();
        Assertions.assertThat((InputStream)new ByteArrayInputStream((byte[])Mono.from((Publisher)this.testee().read(blobId)).block())).hasSameContentAs((InputStream)new ByteArrayInputStream(emptyByteArray));
    }
}

