/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreFixture;
import org.apache.james.blob.cassandra.CassandraBucketDAO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class CassandraBucketDAOTest {
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraBlobModule.MODULE);
    private CassandraBucketDAO testee;

    CassandraBucketDAOTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.testee = new CassandraBucketDAO((BlobId.Factory)new HashBlobId.Factory(), (CqlSession)cassandraCluster.getCassandraCluster().getConf());
    }

    @Test
    void readPartShouldReturnEmptyWhenNone() {
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
    }

    @Test
    void deletePositionShouldNotThrowWhenMissing() {
        Assertions.assertThatCode(() -> this.testee.deletePosition(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).block()).doesNotThrowAnyException();
    }

    @Test
    void deletePartShouldNotThrowWhenMissing() {
        Assertions.assertThatCode(() -> this.testee.deleteParts(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).block()).doesNotThrowAnyException();
    }

    @Test
    void selectRowCountShouldNotReturnDeletedData() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 17).block();
        this.testee.deletePosition(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).block();
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).isEmpty();
    }

    @Test
    void readPartShouldNotReturnDeletedItem() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).block();
        this.testee.deleteParts(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
    }

    @Test
    void readPartShouldNotReturnDeletedItems() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).block();
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 43).block();
        this.testee.deleteParts(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Optional maybeBytes2 = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 43).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
        Assertions.assertThat((Optional)maybeBytes2).isEmpty();
    }

    @Test
    void readPartShouldReturnPreviouslySavedData() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).contains((Object)ByteBuffer.wrap(CassandraBlobStoreFixture.DATA));
    }

    @Test
    void readPartShouldNotReturnContentOfOtherParts() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 43).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
    }

    @Test
    void readPartShouldNotReturnContentOfOtherBuckets() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME_2, CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).isEmpty();
    }

    @Test
    void readPartShouldReturnLatestValue() {
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).block();
        this.testee.writePart(ByteBuffer.wrap(CassandraBlobStoreFixture.DATA_2), CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).block();
        Optional maybeBytes = this.testee.readPart(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 42).blockOptional();
        Assertions.assertThat((Optional)maybeBytes).contains((Object)ByteBuffer.wrap(CassandraBlobStoreFixture.DATA_2));
    }

    @Test
    void selectRowCountShouldReturnEmptyByDefault() {
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).isEmpty();
    }

    @Test
    void selectRowCountShouldReturnPreviouslySavedValue() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 17).block();
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).contains((Object)17);
    }

    @Test
    void selectRowCountShouldNotReturnOtherBlobIdValue() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 17).block();
        Optional maybeRowCount = this.testee.selectRowCount(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID_2).blockOptional();
        Assertions.assertThat((Optional)maybeRowCount).isEmpty();
    }

    @Test
    void listAllShouldReturnEmptyWhenNone() {
        Assertions.assertThat((Stream)this.testee.listAll().toStream()).isEmpty();
    }

    @Test
    void listAllShouldReturnPreviouslyInsertedData() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 17).block();
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BUCKET_NAME_2, CassandraBlobStoreFixture.BLOB_ID, 17).block();
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID_2, 17).block();
        Assertions.assertThat((Stream)this.testee.listAll().toStream()).containsOnly((Object[])new Pair[]{Pair.of((Object)CassandraBlobStoreFixture.BUCKET_NAME, (Object)CassandraBlobStoreFixture.BLOB_ID), Pair.of((Object)CassandraBlobStoreFixture.BUCKET_NAME_2, (Object)CassandraBlobStoreFixture.BLOB_ID), Pair.of((Object)CassandraBlobStoreFixture.BUCKET_NAME, (Object)CassandraBlobStoreFixture.BLOB_ID_2)});
    }

    @Test
    void listAllShouldNotReturnDeletedData() {
        this.testee.saveBlobPartsReferences(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID, 17).block();
        this.testee.deletePosition(CassandraBlobStoreFixture.BUCKET_NAME, CassandraBlobStoreFixture.BLOB_ID).block();
        Assertions.assertThat((Stream)this.testee.listAll().toStream()).isEmpty();
    }
}

