/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.DeduplicationBlobStoreContract;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.api.MetricableBlobStore;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreContract;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.cassandra.CassandraBucketDAO;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.server.blob.deduplication.BlobStoreFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

public class CassandraBlobStoreTest
implements CassandraBlobStoreContract,
DeduplicationBlobStoreContract {
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraBlobModule.MODULE);
    private BlobStore testee;
    private CassandraDefaultBucketDAO defaultBucketDAO;

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        HashBlobId.Factory blobIdFactory = new HashBlobId.Factory();
        CassandraBucketDAO bucketDAO = new CassandraBucketDAO((BlobId.Factory)blobIdFactory, (CqlSession)cassandra.getConf());
        this.defaultBucketDAO = (CassandraDefaultBucketDAO)Mockito.spy((Object)new CassandraDefaultBucketDAO((CqlSession)cassandra.getConf(), (BlobId.Factory)blobIdFactory));
        CassandraConfiguration cassandraConfiguration = CassandraConfiguration.builder().blobPartSize(10240).build();
        RecordingMetricFactory metricFactory = metricsTestExtension.getMetricFactory();
        this.testee = new MetricableBlobStore((MetricFactory)metricFactory, BlobStoreFactory.builder().blobStoreDAO((BlobStoreDAO)new CassandraBlobStoreDAO(this.defaultBucketDAO, bucketDAO, cassandraConfiguration, BucketName.DEFAULT, (MetricFactory)metricFactory)).blobIdFactory((BlobId.Factory)blobIdFactory).defaultBucketName().deduplication());
    }

    public BlobStore testee() {
        return this.testee;
    }

    public BlobId.Factory blobIdFactory() {
        return new HashBlobId.Factory();
    }

    @Override
    public CassandraDefaultBucketDAO defaultBucketDAO() {
        return this.defaultBucketDAO;
    }
}

