/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BlobStoreDAOContract;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.TestBlobId;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.cassandra.CassandraBucketDAO;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CassandraBlobStoreDAOTest
implements BlobStoreDAOContract {
    private static final int CHUNK_SIZE = 10240;
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraBlobModule.MODULE);
    private BlobStoreDAO testee;
    private CassandraDefaultBucketDAO defaultBucketDAO;

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        TestBlobId.Factory blobIdFactory = new TestBlobId.Factory();
        CassandraBucketDAO bucketDAO = new CassandraBucketDAO((BlobId.Factory)blobIdFactory, (CqlSession)cassandra.getConf());
        this.defaultBucketDAO = new CassandraDefaultBucketDAO((CqlSession)cassandra.getConf(), (BlobId.Factory)blobIdFactory);
        this.testee = new CassandraBlobStoreDAO(this.defaultBucketDAO, bucketDAO, CassandraConfiguration.builder().blobPartSize(10240).build(), BucketName.DEFAULT, (MetricFactory)new RecordingMetricFactory());
    }

    public BlobStoreDAO testee() {
        return this.testee;
    }

    @Disabled(value="Not supported by the Cassandra blob store")
    public void listBucketsShouldReturnBucketsWithNoBlob() {
    }
}

