/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.api.MetricableBlobStore;
import org.apache.james.blob.api.ObjectStoreException;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreContract;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.cassandra.CassandraBucketDAO;
import org.apache.james.blob.cassandra.CassandraDefaultBucketDAO;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.server.blob.deduplication.BlobStoreFactory;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class CassandraBlobStoreClOneTest
implements CassandraBlobStoreContract {
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraBlobModule.MODULE);
    private BlobStore testee;
    private CassandraDefaultBucketDAO defaultBucketDAO;

    CassandraBlobStoreClOneTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        HashBlobId.Factory blobIdFactory = new HashBlobId.Factory();
        CassandraBucketDAO bucketDAO = new CassandraBucketDAO((BlobId.Factory)blobIdFactory, (CqlSession)cassandra.getConf());
        this.defaultBucketDAO = (CassandraDefaultBucketDAO)Mockito.spy((Object)new CassandraDefaultBucketDAO((CqlSession)cassandra.getConf(), (BlobId.Factory)blobIdFactory));
        CassandraConfiguration cassandraConfiguration = CassandraConfiguration.builder().blobPartSize(10240).optimisticConsistencyLevel(true).build();
        RecordingMetricFactory metricFactory = metricsTestExtension.getMetricFactory();
        this.testee = new MetricableBlobStore((MetricFactory)metricFactory, BlobStoreFactory.builder().blobStoreDAO((BlobStoreDAO)new CassandraBlobStoreDAO(this.defaultBucketDAO, bucketDAO, cassandraConfiguration, BucketName.DEFAULT, (MetricFactory)metricFactory)).blobIdFactory((BlobId.Factory)blobIdFactory).defaultBucketName().deduplication());
    }

    public BlobStore testee() {
        return this.testee;
    }

    public BlobId.Factory blobIdFactory() {
        return new HashBlobId.Factory();
    }

    @Override
    public CassandraDefaultBucketDAO defaultBucketDAO() {
        return this.defaultBucketDAO;
    }

    @Override
    @Test
    public void readShouldNotReturnInvalidResultsWhenPartialDataPresent() {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().readPartClOne(blobId, 1)).thenReturn((Object)Mono.empty());
        Mockito.when((Object)this.defaultBucketDAO().readPart(blobId, 1)).thenReturn((Object)Mono.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IOUtils.toString((InputStream)this.testee().read(this.testee().getDefaultBucketName(), blobId), (Charset)StandardCharsets.UTF_8)).isInstanceOf(ObjectStoreException.class)).hasMessageContaining("Missing blob part for blobId");
    }

    @Override
    @Test
    public void readBytesShouldNotReturnInvalidResultsWhenPartialDataPresent() {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().readPartClOne(blobId, 1)).thenReturn((Object)Mono.empty());
        Mockito.when((Object)this.defaultBucketDAO().readPart(blobId, 1)).thenReturn((Object)Mono.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Mono.from((Publisher)this.testee().readBytes(this.testee().getDefaultBucketName(), blobId)).block()).isInstanceOf(ObjectStoreException.class)).hasMessageContaining("Missing blob part for blobId");
    }

    @Test
    void readShouldReturnValidResultWhenDataMissingInOneNodeButPresentInOthers() throws IOException {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().selectRowCountClOne(blobId)).thenReturn((Object)Mono.empty());
        String data = IOUtils.toString((InputStream)this.testee().read(this.testee().getDefaultBucketName(), blobId), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((String)data).isEqualTo(longString);
    }

    @Test
    void readBytesShouldReturnValidResultWhenDataMissingInOneNodeButPresentInOthers() {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().selectRowCountClOne(blobId)).thenReturn((Object)Mono.empty());
        byte[] bytes = (byte[])Mono.from((Publisher)this.testee().readBytes(this.testee().getDefaultBucketName(), blobId)).block();
        Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEqualTo(longString);
    }

    @Test
    void readShouldReturnValidResultWhenPartialDataMissingInOneNodeButPresentInOthers() throws IOException {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().readPartClOne(blobId, 1)).thenReturn((Object)Mono.empty());
        String data = IOUtils.toString((InputStream)this.testee().read(this.testee().getDefaultBucketName(), blobId), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((String)data).isEqualTo(longString);
    }

    @Test
    void readBytesShouldReturnValidResultWhenPartialDataMissingInOneNodeButPresentInOthers() {
        int repeatCount = 30720;
        String longString = Strings.repeat((String)"0123456789\n", (int)repeatCount);
        BlobId blobId = (BlobId)Mono.from((Publisher)this.testee().save(this.testee().getDefaultBucketName(), longString, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().readPartClOne(blobId, 1)).thenReturn((Object)Mono.empty());
        byte[] bytes = (byte[])Mono.from((Publisher)this.testee().readBytes(this.testee().getDefaultBucketName(), blobId)).block();
        Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEqualTo(longString);
    }

    @Test
    void readShouldPublishHitRatioClOneMetric() {
        BlobStore store = this.testee();
        BlobId blobId = (BlobId)Mono.from((Publisher)store.save(store.getDefaultBucketName(), BYTES_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        store.read(store.getDefaultBucketName(), blobId);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> Assertions.assertThat((int)metricsTestExtension.getMetricFactory().countFor("cassandraBlobStoreClOneHits")).isEqualTo(2));
    }

    @Test
    void readBytesShouldPublishHitRatioClOneMetric() {
        BlobStore store = this.testee();
        BlobId blobId = (BlobId)Mono.from((Publisher)store.save(store.getDefaultBucketName(), BYTES_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        Mono.from((Publisher)store.readBytes(store.getDefaultBucketName(), blobId)).block();
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> Assertions.assertThat((int)metricsTestExtension.getMetricFactory().countFor("cassandraBlobStoreClOneHits")).isEqualTo(2));
    }

    @Test
    void readShouldPublishMissRatioClOneMetric() {
        BlobStore store = this.testee();
        BlobId blobId = (BlobId)Mono.from((Publisher)store.save(store.getDefaultBucketName(), BYTES_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().selectRowCountClOne(blobId)).thenReturn((Object)Mono.empty());
        store.read(store.getDefaultBucketName(), blobId);
        Mockito.when((Object)this.defaultBucketDAO().readPartClOne(blobId, 1)).thenReturn((Object)Mono.empty());
        store.read(store.getDefaultBucketName(), blobId);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> Assertions.assertThat((int)metricsTestExtension.getMetricFactory().countFor("cassandraBlobStoreClOneMisses")).isGreaterThanOrEqualTo(2));
    }

    @Test
    void readBytesShouldPublishMissRatioClOneMetric() {
        BlobStore store = this.testee();
        BlobId blobId = (BlobId)Mono.from((Publisher)store.save(store.getDefaultBucketName(), BYTES_CONTENT, BlobStore.StoragePolicy.LOW_COST)).block();
        Mockito.when((Object)this.defaultBucketDAO().selectRowCountClOne(blobId)).thenReturn((Object)Mono.empty());
        Mono.from((Publisher)store.readBytes(store.getDefaultBucketName(), blobId)).block();
        Mockito.when((Object)this.defaultBucketDAO().readPartClOne(blobId, 1)).thenReturn((Object)Mono.empty());
        Mono.from((Publisher)store.readBytes(store.getDefaultBucketName(), blobId)).block();
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> Assertions.assertThat((int)metricsTestExtension.getMetricFactory().countFor("cassandraBlobStoreClOneMisses")).isGreaterThanOrEqualTo(2));
    }
}

